package io.gamedock.sdk.ads.providers.improvedigital;

import io.gamedock.sdk.ads.providers.AdProvider;
import io.gamedock.sdk.ads.providers.init.BaseAdProviderInit;
import io.gamedock.sdk.ads.providers.init.InitializationStatus;

/**
 * Class used to define initialization properties for the Improve Digital provider.
 */
public class ImproveDigitalProvider {
    public static final String PRIVACY_POLICY_URL = "https://www.improvedigital.com/privacy-policy/";

    public static InitializationStatus initializeImproveDigital(Init init) {
        InitializationStatus status = new InitializationStatus();
        status.setAdProvider(AdProvider.IMPROVE_DIGITAL);
        status.setStatus(InitializationStatus.Status.READY);
        return status;
    }

    public static class Init extends BaseAdProviderInit {

    }
}
