package io.gamedock.sdk.ads.core.tracking;

import android.content.Context;

import io.gamedock.sdk.ads.core.request.AdType;
import io.gamedock.sdk.ads.core.request.BaseRequest;
import io.gamedock.sdk.ads.core.request.RequestType;

/**
 * Calls implementing the BaseRequest. Used for sending tracking information to the ad providers.
 */
public class TrackingRequest extends BaseRequest {
    private String trackingUrl;

    public TrackingRequest(Context context, String trackingUrl) {
        super(context, AdType.NONE, RequestType.TRACKING, null);
        this.trackingUrl = trackingUrl;
    }

    @Override
    public String getUrl() {
        return trackingUrl;
    }
}
