package io.gamedock.sdk.ads.utils.logging;

import android.util.Log;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import io.gamedock.sdk.ads.GamedockAds;

/**
 * Class used to log information from the module.
 */
public class LoggingUtilAds {

    public static String TAG = "GamedockAds";

    public static String getLog() {
        try {
            Process process = Runtime.getRuntime().exec("logcat -d");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));

            StringBuilder log = new StringBuilder();
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                log.append(line);
            }
            return log.toString();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private enum enumLogLevel {
        DEBUG,
        ASSERT,
        ERROR,
        WARN,
        INFO,
        VERBOSE
    }

    public static void d(String logMessage) {
        Log(logMessage, enumLogLevel.DEBUG);
    }

    public static void a(String logMessage) {
        Log(logMessage, enumLogLevel.ASSERT);
    }

    public static void e(String logMessage) {
        Log(logMessage, enumLogLevel.ERROR);
    }

    public static void w(String logMessage) {
        Log(logMessage, enumLogLevel.WARN);
    }

    public static void i(String logMessage) {
        Log(logMessage, enumLogLevel.INFO);
    }

    public static void v(String logMessage) {
        Log(logMessage, enumLogLevel.VERBOSE);
    }

    private static void Log(String logMessage, enumLogLevel logLevel) {
        if (!GamedockAds.getInstance().getSettings().isDebugModeEnabled()) {
            return;
        }

        switch (logLevel) {
            case DEBUG:
                Log.d(TAG, logMessage);
                break;
            case ASSERT:
            case WARN:
                Log.w(TAG, logMessage);
                break;
            case ERROR:
                Log.e(TAG, logMessage);
                break;
            case INFO:
                Log.i(TAG, logMessage);
                break;
            case VERBOSE:
                Log.v(TAG, logMessage);
                break;
        }
    }

}
