package io.gamedock.sdk.ads.utils.image;

import android.content.Context;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

/**
 * Class used for managing the images stored by the Picasso library.
 */
public class ImageUtils {
    public static File getImageFile(Context context, String url) {
        final String CACHE_PATH = context.getCacheDir().getAbsolutePath() + "/picasso-cache/";

        File[] files = new File(CACHE_PATH).listFiles();
        for (File file : files) {
            String fname = file.getName();
            if (fname.contains(".") && fname.substring(fname.lastIndexOf(".")).equals(".0")) {
                try {
                    BufferedReader br = new BufferedReader(new FileReader(file));
                    if (br.readLine().equals(url)) {
                        File imgfile = new File(CACHE_PATH + fname.replace(".0", ".1"));

                        if (imgfile.exists()) {
                            return imgfile;
                        }
                    }
                } catch (IOException e) {
                }
            }
        }
        return null;
    }
}
