package io.gamedock.sdk.ads.utils.error;

/**
 * Enum class used to define all the error codes for the module.
 */
public enum ErrorCodes {
    NotInitialized(1, "NotInitialized", "The Ads module was not initialized correctly."),
    ConnectionError(2, "ConnectionError", "Connection could not be established with the server."),
    NoFill(3, "NoFill", "No ad fill from the server."),
    NullContext(4, "NullContext", "The current context is null."),
    NullPlacementId(5, "NullPlacementId", "The current placement id is null."),
    UnknownProvider(6, "UnknownProvider", "The current supplied provider is unknown."),
    InvalidResponse(7, "InvalidResponse", " The received response from the server is invalid."),
    AssetDownload(8, "AssetDownload", "Assets required for displaying the ad could not be downloaded."),
    EmptyAdData(9, "EmptyAdData", "Information required for displaying the ad is empty."),
    PlayerError(10, "PlayerError", "The video ad player encountered an error."),
    NotLoaded(11, "NotLoaded", "The ad was not loaded."),
    ViewDestroyed(12, "ViewDestroyed", "The view was destroyed. Create a new view to see ads.");

    private int id;
    private String name;
    private String message;

    ErrorCodes(int id, String name, String message) {
        this.id = id;
        this.name = name;
        this.message = message;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getMessage() {
        return message;
    }

    public ErrorCodes setMessage(String message) {
        if (message != null) {
            this.message = message;
        }

        return this;
    }
}
