package io.gamedock.sdk.ads.providers.improvedigital;

import org.json.JSONException;
import org.json.JSONObject;

import io.gamedock.sdk.ads.core.request.AdType;
import io.gamedock.sdk.ads.core.request.BaseResponse;
import io.gamedock.sdk.ads.utils.error.ErrorCodes;
import io.gamedock.sdk.ads.utils.logging.LoggingUtilAds;
import io.gamedock.sdk.ads.utils.values.StaticValues;

/**
 * Class that implements the Improve Digital Response processing logic.
 */
public class ImproveDigitalResponse extends BaseResponse {
    private String type;
    private String adm;
    private String clickUrl;

    private int height;
    private int width;

    private int imageHeight;
    private int imageWidth;

    private String burl;
    private float price;
    private String currency;
    private String cid;
    private String crid;

    public ImproveDigitalResponse(String responseJSON, AdType adType) {
        super(adType);

        LoggingUtilAds.d("Improve Digital request type: " + adType + " with response: " + responseJSON);

        try {
            JSONObject jsonObject = new JSONObject(responseJSON);

            if (!jsonObject.has("type")) {
                isError = true;
                error = ErrorCodes.InvalidResponse;
                return;
            }

            type = jsonObject.getString("type");

            switch (type) {
                case StaticValues.IMAGE:
                    if (!validResponse(jsonObject, StaticValues.IMAGE)) {
                        isError = true;
                        error = ErrorCodes.InvalidResponse;
                    } else {
                        adm = jsonObject.getString("adm");
                        clickUrl = jsonObject.getString("clickUrl");

                        height = jsonObject.getInt("height");
                        width = jsonObject.getInt("width");

                        imageHeight = jsonObject.getInt("imageHeight");
                        imageWidth = jsonObject.getInt("imageWidth");

                        burl = jsonObject.getString("burl");
                        price = (float) jsonObject.getInt("price");
                        currency = jsonObject.getString("currency");
                        cid = jsonObject.getString("cid");
                        crid = jsonObject.getString("crid");
                    }
                    break;
                case StaticValues.HTML:
                    if (!validResponse(jsonObject, StaticValues.HTML)) {
                        isError = true;
                        error = ErrorCodes.InvalidResponse;
                    } else {
                        adm = jsonObject.getString("adm");

                        height = jsonObject.getInt("height");
                        width = jsonObject.getInt("width");

                        burl = jsonObject.getString("burl");
                        price = (float) jsonObject.getInt("price");
                        currency = jsonObject.getString("currency");
                        cid = jsonObject.getString("cid");
                        crid = jsonObject.getString("crid");
                    }
                    break;
                case StaticValues.VAST:
                    if (!validResponse(jsonObject, StaticValues.VAST)) {
                        isError = true;
                        error = ErrorCodes.InvalidResponse;
                    } else {
                        adm = jsonObject.getString("adm");

                        height = jsonObject.getInt("height");
                        width = jsonObject.getInt("width");

                        price = (float) jsonObject.getInt("price");
                        currency = jsonObject.getString("currency");
                        cid = jsonObject.getString("cid");
                        crid = jsonObject.getString("crid");
                    }
                    break;
                case StaticValues.VIDEO:

                    break;
                case StaticValues.ERROR:
                    isError = true;
                    if (validResponse(jsonObject, StaticValues.ERROR)) {
                        String errorCode = jsonObject.getString("errorCode");
                        if (errorCode.equals("NO_AD")) {
                            error = ErrorCodes.NoFill;
                        } else {
                            error = ErrorCodes.InvalidResponse;
                        }
                    } else {
                        error = ErrorCodes.InvalidResponse;
                    }
                    break;
            }

        } catch (JSONException e) {
            e.printStackTrace();
            isError = true;
            error = ErrorCodes.InvalidResponse;
        }
    }

    @Override
    public boolean validResponse(JSONObject jsonObject, String type) {
        boolean valid = true;

        switch (type) {
            case StaticValues.IMAGE:
                if (!jsonObject.has("adm") || !jsonObject.has("clickUrl")
                        || !jsonObject.has("height") || !jsonObject.has("width")
                        || !jsonObject.has("imageHeight") || !jsonObject.has("imageWidth") || !jsonObject.has("burl")
                        || !jsonObject.has("price") || !jsonObject.has("currency")
                        || !jsonObject.has("cid") || !jsonObject.has("crid")) {
                    valid = false;
                }
                break;
            case StaticValues.HTML:
                if (!jsonObject.has("adm") || !jsonObject.has("height") || !jsonObject.has("width") || !jsonObject.has("burl")
                        || !jsonObject.has("price") || !jsonObject.has("currency")
                        || !jsonObject.has("cid") || !jsonObject.has("crid")) {
                    valid = false;
                }
                break;
            case StaticValues.VAST:
                if (!jsonObject.has("adm") || !jsonObject.has("height") || !jsonObject.has("width")
                        || !jsonObject.has("price") || !jsonObject.has("currency")
                        || !jsonObject.has("cid") || !jsonObject.has("crid")) {
                    valid = false;
                }
                break;
            case StaticValues.VIDEO:

                break;
            case StaticValues.ERROR:
                if (!jsonObject.has("errorCode") || !jsonObject.has("subErrorCode")) {
                    valid = false;
                }
                break;
        }

        return valid;
    }

    public String getType() {
        return type;
    }

    public String getClickUrl() {
        return clickUrl;
    }

    public String getAdm() {
        return adm;
    }

    public int getHeight() {
        return height;
    }

    public int getWidth() {
        return width;
    }

    public int getImageHeight() {
        return imageHeight;
    }

    public int getImageWidth() {
        return imageWidth;
    }

    public String getBurl() {
        return burl;
    }

    public float getPrice() {
        return price;
    }

    public String getCurrency() {
        return currency;
    }

    public String getCid() {
        return cid;
    }

    public String getCrid() {
        return crid;
    }
}
