package io.gamedock.sdk.ads.core.request;


import org.json.JSONObject;

import io.gamedock.sdk.ads.utils.error.ErrorCodes;

/**
 * Base class containing general logic for all the responses.
 */
public abstract class BaseResponse {
    private AdType adType;
    protected boolean isError;
    protected ErrorCodes error;

    public BaseResponse(AdType adType) {
        this.adType = adType;
    }

    public AdType getAdType() {
        return adType;
    }

    public void setAdType(AdType adType) {
        this.adType = adType;
    }

    public boolean isError() {
        return isError;
    }

    public ErrorCodes getError() {
        return error;
    }

    public abstract boolean validResponse(JSONObject jsonObject, String type);
}
