package io.gamedock.sdk.ads.core.base.web;

public class AdWebViewPreparer {
    public static final String HTML_BASE_URL = "https://ad.360yield.com/";

    public static final String HTML_CODE_STARTING_CONTENT_NO_BODY_START = "<html><head><meta name=\"viewport\" content=\"initial-scale=1, maximum-scale=1\"><style>*{margin:0;padding:0}</style></head>";
    public static final String HTML_CODE_STARTING_CONTENT_NO_BODY_END = "</html>";

    public static final String HTML_CODE_STARTING_CONTENT_START = "<html><head><meta name=\"viewport\" content=\"initial-scale=1, maximum-scale=1\"><style>*{margin:0;padding:0}</style></head><body>";
    public static final String HTML_CODE_STARTING_CONTENT_END = "</body></html>";

    public static String prepareWebViewUrl(String adContent) {
        String finalContent = "";

        if (hasHtmlTags(adContent)) {
            return adContent;
        }

        if (hasBodyTags(adContent)) {
            finalContent = HTML_CODE_STARTING_CONTENT_NO_BODY_START + adContent + HTML_CODE_STARTING_CONTENT_NO_BODY_END;
        } else {
            finalContent = HTML_CODE_STARTING_CONTENT_START + adContent + HTML_CODE_STARTING_CONTENT_END;
        }

        return finalContent;
    }

    private static boolean hasBodyTags(String adContent) {
        return adContent.contains("<body>") && adContent.contains("</body>");
    }

    private static boolean hasHtmlTags(String adContent) {
        return adContent.contains("<html>") && adContent.contains("</html>");
    }
}
