package io.gaiapipeline.proto;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.14.0)",
    comments = "Source: plugin.proto")
public final class PluginGrpc {

  private PluginGrpc() {}

  public static final String SERVICE_NAME = "proto.Plugin";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<io.gaiapipeline.proto.Empty,
      io.gaiapipeline.proto.Job> getGetJobsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetJobs",
      requestType = io.gaiapipeline.proto.Empty.class,
      responseType = io.gaiapipeline.proto.Job.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<io.gaiapipeline.proto.Empty,
      io.gaiapipeline.proto.Job> getGetJobsMethod() {
    io.grpc.MethodDescriptor<io.gaiapipeline.proto.Empty, io.gaiapipeline.proto.Job> getGetJobsMethod;
    if ((getGetJobsMethod = PluginGrpc.getGetJobsMethod) == null) {
      synchronized (PluginGrpc.class) {
        if ((getGetJobsMethod = PluginGrpc.getGetJobsMethod) == null) {
          PluginGrpc.getGetJobsMethod = getGetJobsMethod = 
              io.grpc.MethodDescriptor.<io.gaiapipeline.proto.Empty, io.gaiapipeline.proto.Job>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(
                  "proto.Plugin", "GetJobs"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.gaiapipeline.proto.Empty.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.gaiapipeline.proto.Job.getDefaultInstance()))
                  .setSchemaDescriptor(new PluginMethodDescriptorSupplier("GetJobs"))
                  .build();
          }
        }
     }
     return getGetJobsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.gaiapipeline.proto.Job,
      io.gaiapipeline.proto.JobResult> getExecuteJobMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ExecuteJob",
      requestType = io.gaiapipeline.proto.Job.class,
      responseType = io.gaiapipeline.proto.JobResult.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.gaiapipeline.proto.Job,
      io.gaiapipeline.proto.JobResult> getExecuteJobMethod() {
    io.grpc.MethodDescriptor<io.gaiapipeline.proto.Job, io.gaiapipeline.proto.JobResult> getExecuteJobMethod;
    if ((getExecuteJobMethod = PluginGrpc.getExecuteJobMethod) == null) {
      synchronized (PluginGrpc.class) {
        if ((getExecuteJobMethod = PluginGrpc.getExecuteJobMethod) == null) {
          PluginGrpc.getExecuteJobMethod = getExecuteJobMethod = 
              io.grpc.MethodDescriptor.<io.gaiapipeline.proto.Job, io.gaiapipeline.proto.JobResult>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "proto.Plugin", "ExecuteJob"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.gaiapipeline.proto.Job.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.gaiapipeline.proto.JobResult.getDefaultInstance()))
                  .setSchemaDescriptor(new PluginMethodDescriptorSupplier("ExecuteJob"))
                  .build();
          }
        }
     }
     return getExecuteJobMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static PluginStub newStub(io.grpc.Channel channel) {
    return new PluginStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static PluginBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new PluginBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static PluginFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new PluginFutureStub(channel);
  }

  /**
   */
  public static abstract class PluginImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * GetJobs returns a stream of Job objects.
     * Used to expose jobs to gaia.
     * </pre>
     */
    public void getJobs(io.gaiapipeline.proto.Empty request,
        io.grpc.stub.StreamObserver<io.gaiapipeline.proto.Job> responseObserver) {
      asyncUnimplementedUnaryCall(getGetJobsMethod(), responseObserver);
    }

    /**
     * <pre>
     * ExecuteJob signals the plugin to execute the given job.
     * Used to execute one job from a pipeline.
     * </pre>
     */
    public void executeJob(io.gaiapipeline.proto.Job request,
        io.grpc.stub.StreamObserver<io.gaiapipeline.proto.JobResult> responseObserver) {
      asyncUnimplementedUnaryCall(getExecuteJobMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getGetJobsMethod(),
            asyncServerStreamingCall(
              new MethodHandlers<
                io.gaiapipeline.proto.Empty,
                io.gaiapipeline.proto.Job>(
                  this, METHODID_GET_JOBS)))
          .addMethod(
            getExecuteJobMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.gaiapipeline.proto.Job,
                io.gaiapipeline.proto.JobResult>(
                  this, METHODID_EXECUTE_JOB)))
          .build();
    }
  }

  /**
   */
  public static final class PluginStub extends io.grpc.stub.AbstractStub<PluginStub> {
    private PluginStub(io.grpc.Channel channel) {
      super(channel);
    }

    private PluginStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PluginStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new PluginStub(channel, callOptions);
    }

    /**
     * <pre>
     * GetJobs returns a stream of Job objects.
     * Used to expose jobs to gaia.
     * </pre>
     */
    public void getJobs(io.gaiapipeline.proto.Empty request,
        io.grpc.stub.StreamObserver<io.gaiapipeline.proto.Job> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(getGetJobsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * ExecuteJob signals the plugin to execute the given job.
     * Used to execute one job from a pipeline.
     * </pre>
     */
    public void executeJob(io.gaiapipeline.proto.Job request,
        io.grpc.stub.StreamObserver<io.gaiapipeline.proto.JobResult> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getExecuteJobMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   */
  public static final class PluginBlockingStub extends io.grpc.stub.AbstractStub<PluginBlockingStub> {
    private PluginBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private PluginBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PluginBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new PluginBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * GetJobs returns a stream of Job objects.
     * Used to expose jobs to gaia.
     * </pre>
     */
    public java.util.Iterator<io.gaiapipeline.proto.Job> getJobs(
        io.gaiapipeline.proto.Empty request) {
      return blockingServerStreamingCall(
          getChannel(), getGetJobsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * ExecuteJob signals the plugin to execute the given job.
     * Used to execute one job from a pipeline.
     * </pre>
     */
    public io.gaiapipeline.proto.JobResult executeJob(io.gaiapipeline.proto.Job request) {
      return blockingUnaryCall(
          getChannel(), getExecuteJobMethod(), getCallOptions(), request);
    }
  }

  /**
   */
  public static final class PluginFutureStub extends io.grpc.stub.AbstractStub<PluginFutureStub> {
    private PluginFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private PluginFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PluginFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new PluginFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * ExecuteJob signals the plugin to execute the given job.
     * Used to execute one job from a pipeline.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.gaiapipeline.proto.JobResult> executeJob(
        io.gaiapipeline.proto.Job request) {
      return futureUnaryCall(
          getChannel().newCall(getExecuteJobMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_GET_JOBS = 0;
  private static final int METHODID_EXECUTE_JOB = 1;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final PluginImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(PluginImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_GET_JOBS:
          serviceImpl.getJobs((io.gaiapipeline.proto.Empty) request,
              (io.grpc.stub.StreamObserver<io.gaiapipeline.proto.Job>) responseObserver);
          break;
        case METHODID_EXECUTE_JOB:
          serviceImpl.executeJob((io.gaiapipeline.proto.Job) request,
              (io.grpc.stub.StreamObserver<io.gaiapipeline.proto.JobResult>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class PluginBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    PluginBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.gaiapipeline.proto.GRPCPlugin.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("Plugin");
    }
  }

  private static final class PluginFileDescriptorSupplier
      extends PluginBaseDescriptorSupplier {
    PluginFileDescriptorSupplier() {}
  }

  private static final class PluginMethodDescriptorSupplier
      extends PluginBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    PluginMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (PluginGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new PluginFileDescriptorSupplier())
              .addMethod(getGetJobsMethod())
              .addMethod(getExecuteJobMethod())
              .build();
        }
      }
    }
    return result;
  }
}
