/*
 * Decompiled with CFR 0.152.
 */
package io.gaiapipeline.javasdk;

import io.gaiapipeline.javasdk.ExitPipelineException;
import io.gaiapipeline.javasdk.JobsWrapper;
import io.gaiapipeline.javasdk.PipelineJob;
import io.gaiapipeline.proto.Empty;
import io.gaiapipeline.proto.Job;
import io.gaiapipeline.proto.JobResult;
import io.gaiapipeline.proto.PluginGrpc;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.protobuf.services.ProtoReflectionService;
import io.grpc.services.HealthStatusManager;
import io.grpc.stub.StreamObserver;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.logging.Logger;

public class Javasdk {
    private static final int CORE_PROTOCOL_VERSION = 1;
    private static final int PROTOCOL_VERSION = 2;
    private static final String PROTOCOL_NAME = "tcp";
    private static final String PROTOCOL_TYPE = "grpc";
    private static ArrayList<JobsWrapper> cachedJobs;
    private static final int FNV_32_INIT = -2128831035;
    private static final int FNV_32_PRIME = 16777619;
    private static final String LISTEN_ADDR = "localhost";
    private final String certChainFilePath = System.getenv("GAIA_PLUGIN_CERT");
    private final String privateKeyFilePath = System.getenv("GAIA_PLUGIN_KEY");
    private final String trustCertCollectionFilePath = System.getenv("GAIA_PLUGIN_CA_CERT");
    private static final Logger logger;

    public void Serve(ArrayList<PipelineJob> jobs) throws Exception {
        cachedJobs = new ArrayList();
        for (PipelineJob job : jobs) {
            Job grpcJob = Job.newBuilder().setUniqueId(Javasdk.getHash(job.getTitle())).setTitle(job.getTitle()).setDescription(job.getDescription()).setPriority(job.getPriority()).build();
            JobsWrapper wrapper = new JobsWrapper();
            wrapper.setJob(grpcJob);
            wrapper.setHandler(job.getHandler());
            cachedJobs.add(wrapper);
        }
        for (int x = 0; x < cachedJobs.size(); ++x) {
            for (int y = 0; y < cachedJobs.size(); ++y) {
                if (x == y || cachedJobs.get(x).getJob().getUniqueId() != cachedJobs.get(y).getJob().getUniqueId()) continue;
                throw new Exception("duplicate job: At least two jobs with the same title found. This is not allowed!");
            }
        }
        HealthStatusManager health = new HealthStatusManager();
        health.setStatus("plugin", HealthCheckResponse.ServingStatus.SERVING);
        InetSocketAddress socketAddr = new InetSocketAddress(LISTEN_ADDR, 0);
        final Server server = ((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)socketAddr).addService(health.getHealthService())).addService(ProtoReflectionService.newInstance())).addService((BindableService)new PluginImpl())).sslContext(this.getSslContextBuilder().build()).build().start();
        String connectString = "1|2|tcp|" + socketAddr.getHostName() + ":" + server.getPort() + "|" + PROTOCOL_TYPE + "\n";
        System.out.print(connectString);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                server.shutdown();
            }
        });
        server.awaitTermination();
    }

    private SslContextBuilder getSslContextBuilder() {
        SslContextBuilder sslClientContextBuilder = SslContextBuilder.forServer((File)new File(this.certChainFilePath), (File)new File(this.privateKeyFilePath));
        sslClientContextBuilder.trustManager(new File(this.trustCertCollectionFilePath));
        sslClientContextBuilder.clientAuth(ClientAuth.REQUIRE);
        return GrpcSslContexts.configure((SslContextBuilder)sslClientContextBuilder, (SslProvider)SslProvider.OPENSSL);
    }

    private static int getHash(String s) {
        int rv = -2128831035;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            rv ^= s.charAt(i);
            rv *= 16777619;
        }
        return rv;
    }

    static {
        logger = Logger.getLogger(Javasdk.class.getName());
    }

    static class PluginImpl
    extends PluginGrpc.PluginImplBase {
        PluginImpl() {
        }

        @Override
        public void getJobs(Empty empty, StreamObserver<Job> stream) {
            for (JobsWrapper job : cachedJobs) {
                stream.onNext((Object)job.getJob());
            }
            stream.onCompleted();
        }

        @Override
        public void executeJob(Job job, StreamObserver<JobResult> stream) {
            JobsWrapper jobWrap = null;
            for (JobsWrapper jobWrapper : cachedJobs) {
                if (jobWrapper.getJob().getUniqueId() != job.getUniqueId()) continue;
                jobWrap = jobWrapper;
                break;
            }
            if (jobWrap == null) {
                logger.info("cannot find job " + job.getTitle() + " in pipeline");
                stream.onError((Throwable)new Exception("job not found in plugin"));
                return;
            }
            JobResult.Builder resultBuilder = JobResult.newBuilder();
            try {
                jobWrap.getHandler().executeHandler(job.getArgsMap());
            }
            catch (Exception ex) {
                if (ex instanceof ExitPipelineException) {
                    resultBuilder.setExitPipeline(true);
                } else {
                    resultBuilder.setExitPipeline(true);
                    resultBuilder.setFailed(true);
                }
                resultBuilder.setUniqueId(jobWrap.getJob().getUniqueId());
                resultBuilder.setMessage(ex.getMessage());
            }
            stream.onNext((Object)resultBuilder.build());
            stream.onCompleted();
        }
    }
}

