/*
 * Decompiled with CFR 0.152.
 */
package io.g740.client.util;

import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestTemplateUtils {
    private static final RestTemplate restTemplate = new RestTemplate();

    public static <T> ResponseEntity<T> get(String url, Class<T> responseType) {
        return restTemplate.getForEntity(url, responseType, new Object[0]);
    }

    public static <T> ResponseEntity<T> get(String url, Class<T> responseType, Object ... uriVariables) {
        return restTemplate.getForEntity(url, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> get(String url, Class<T> responseType, Map<String, ?> uriVariables) {
        return restTemplate.getForEntity(url, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> get(String url, Map<String, String> headers, Class<T> responseType, Object ... uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return RestTemplateUtils.get(url, httpHeaders, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> get(String url, HttpHeaders headers, Class<T> responseType, Object ... uriVariables) {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        return RestTemplateUtils.exchange(url, HttpMethod.GET, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> get(String url, Map<String, String> headers, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return RestTemplateUtils.get(url, httpHeaders, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> get(String url, HttpHeaders headers, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        return RestTemplateUtils.exchange(url, HttpMethod.GET, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> post(String url, Class<T> responseType) {
        return restTemplate.postForEntity(url, (Object)HttpEntity.EMPTY, responseType, new Object[0]);
    }

    public static <T> ResponseEntity<T> post(String url, Object requestBody, Class<T> responseType) {
        return restTemplate.postForEntity(url, requestBody, responseType, new Object[0]);
    }

    public static <T> ResponseEntity<T> post(String url, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        return restTemplate.postForEntity(url, requestBody, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> post(String url, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        return restTemplate.postForEntity(url, requestBody, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> post(String url, Map<String, String> headers, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return RestTemplateUtils.post(url, httpHeaders, requestBody, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> post(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return RestTemplateUtils.post(url, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> post(String url, Map<String, String> headers, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return RestTemplateUtils.post(url, httpHeaders, requestBody, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> post(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return RestTemplateUtils.post(url, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> post(String url, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) {
        return restTemplate.exchange(url, HttpMethod.POST, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> post(String url, HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> uriVariables) {
        return restTemplate.exchange(url, HttpMethod.POST, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> put(String url, Class<T> responseType, Object ... uriVariables) {
        return RestTemplateUtils.put(url, HttpEntity.EMPTY, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> put(String url, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody);
        return RestTemplateUtils.put(url, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> put(String url, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody);
        return RestTemplateUtils.put(url, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> put(String url, Map<String, String> headers, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return RestTemplateUtils.put(url, httpHeaders, requestBody, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> put(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return RestTemplateUtils.put(url, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> put(String url, Map<String, String> headers, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return RestTemplateUtils.put(url, httpHeaders, requestBody, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> put(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return RestTemplateUtils.put(url, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> put(String url, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) {
        return restTemplate.exchange(url, HttpMethod.PUT, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> put(String url, HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> uriVariables) {
        return restTemplate.exchange(url, HttpMethod.PUT, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, Class<T> responseType, Object ... uriVariables) {
        return RestTemplateUtils.delete(url, HttpEntity.EMPTY, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, Class<T> responseType, Map<String, ?> uriVariables) {
        return RestTemplateUtils.delete(url, HttpEntity.EMPTY, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody);
        return RestTemplateUtils.delete(url, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody);
        return RestTemplateUtils.delete(url, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, Map<String, String> headers, Class<T> responseType, Object ... uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return RestTemplateUtils.delete(url, httpHeaders, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, HttpHeaders headers, Class<T> responseType, Object ... uriVariables) {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        return RestTemplateUtils.delete(url, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, Map<String, String> headers, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return RestTemplateUtils.delete(url, httpHeaders, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, HttpHeaders headers, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        return RestTemplateUtils.delete(url, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, Map<String, String> headers, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return RestTemplateUtils.delete(url, httpHeaders, requestBody, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return RestTemplateUtils.delete(url, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, Map<String, String> headers, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return RestTemplateUtils.delete(url, httpHeaders, requestBody, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return RestTemplateUtils.delete(url, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) {
        return restTemplate.exchange(url, HttpMethod.DELETE, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> uriVariables) {
        return restTemplate.exchange(url, HttpMethod.DELETE, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) {
        return restTemplate.exchange(url, method, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> uriVariables) {
        return restTemplate.exchange(url, method, requestEntity, responseType, uriVariables);
    }

    public static RestTemplate getRestTemplate() {
        return restTemplate;
    }
}

