/*
 * Decompiled with CFR 0.152.
 */
package io.g740.client.util;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static String contact(String pathPrefix, String ... endpoints) {
        StringBuilder sb = new StringBuilder();
        sb.append(pathPrefix);
        for (String endpoint : endpoints) {
            sb.append(File.separator + endpoint);
        }
        return sb.toString().replaceAll("[/|\\\\]+", "\\" + File.separator);
    }

    public static void initMkdir(String[] filePaths) throws Exception {
        try {
            for (int i = 0; i < filePaths.length; ++i) {
                File file = new File(filePaths[i]);
                if (file.exists()) continue;
                file.mkdirs();
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    public static boolean delAllFile(String path) {
        boolean flag = false;
        File file = new File(path);
        if (!file.exists()) {
            return flag;
        }
        if (!file.isDirectory()) {
            return flag;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            boolean success;
            boolean deleted;
            temp = path.endsWith(File.separator) ? new File(path + tempList[i]) : new File(path + File.separator + tempList[i]);
            if (temp.isFile() && !(deleted = temp.delete())) {
                LOGGER.warn("failed to delete file: {}", (Object)temp.getAbsolutePath());
            }
            if (!temp.isDirectory()) continue;
            FileUtils.delAllFile(path + "/" + tempList[i]);
            flag = success = new File(path + "/" + tempList[i]).delete();
        }
        return flag;
    }
}

