/*
 * Decompiled with CFR 0.152.
 */
package io.g740.client.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtils {
    static java.time.format.DateTimeFormatter format = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral("-").appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral("-").appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral(" ").appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(":").appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(":").appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral(":").toFormatter();
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String DATE_2_PATTERN = "yyyy/MM/dd";
    private static final String DATE_3_PATTERN = "dd/MM/yyyy";
    private static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String DATETIME_2_PATTERN = "yyyy/MM/dd HH:mm:ss";
    private static final String DATETIME_3_PATTERN = "dd/MM/yyyy HH:mm:ss";
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private static final DateTimeFormatter DATE_2_FORMAT = DateTimeFormat.forPattern((String)"yyyy/MM/dd");
    private static final DateTimeFormatter DATE_3_FORMAT = DateTimeFormat.forPattern((String)"dd/MM/yyyy");
    private static final DateTimeFormatter DATETIME_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter DATETIME_2_FORMAT = DateTimeFormat.forPattern((String)"yyyy/MM/dd HH:mm:ss");
    private static final DateTimeFormatter DATETIME_3_FORMAT = DateTimeFormat.forPattern((String)"dd/MM/yyyy HH:mm:ss");

    public static String ofLongStr(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATETIME_PATTERN);
        return sdf.format(date);
    }

    public static Date ofLongDate(String source) {
        try {
            return DATETIME_FORMAT.parseDateTime(source).toDate();
        }
        catch (Exception e) {
            try {
                return DATETIME_2_FORMAT.parseDateTime(source).toDate();
            }
            catch (Exception e2) {
                try {
                    return DATETIME_3_FORMAT.parseDateTime(source).toDate();
                }
                catch (Exception e3) {
                    return null;
                }
            }
        }
    }

    public static Date ofShortDate(String source) {
        try {
            return DATE_FORMAT.parseLocalDate(source).toDate();
        }
        catch (Exception e) {
            try {
                return DATE_2_FORMAT.parseLocalDate(source).toDate();
            }
            catch (Exception e2) {
                try {
                    return DATE_3_FORMAT.parseLocalDate(source).toDate();
                }
                catch (Exception e3) {
                    return null;
                }
            }
        }
    }

    public static String ofShortDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        return sdf.format(date);
    }

    public static Date beforeDays(Date currentDate, Integer days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.add(5, days);
        return calendar.getTime();
    }

    public static Boolean isDate(String dateStr) {
        try {
            DateTime.parse((String)dateStr, (DateTimeFormatter)DATE_FORMAT);
            return true;
        }
        catch (Exception e) {
            try {
                DateTime.parse((String)dateStr, (DateTimeFormatter)DATE_2_FORMAT);
                return true;
            }
            catch (Exception e2) {
                try {
                    DateTime.parse((String)dateStr, (DateTimeFormatter)DATE_3_FORMAT);
                    return true;
                }
                catch (Exception e3) {
                    return false;
                }
            }
        }
    }

    public static Boolean isDateTime(String dateTimeStr) {
        try {
            DateTime.parse((String)dateTimeStr, (DateTimeFormatter)DATETIME_FORMAT);
            return true;
        }
        catch (Exception e) {
            try {
                DateTime.parse((String)dateTimeStr, (DateTimeFormatter)DATETIME_2_FORMAT);
                return true;
            }
            catch (Exception e2) {
                try {
                    DateTime.parse((String)dateTimeStr, (DateTimeFormatter)DATETIME_3_FORMAT);
                    return true;
                }
                catch (Exception e3) {
                    return false;
                }
            }
        }
    }

    public static Integer ofDiffWorkdayByDays(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            throw new RuntimeException("date is null");
        }
        if (d1.getTime() == d2.getTime()) {
            return 0;
        }
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        if (d1.getTime() > d2.getTime()) {
            end.setTime(d1);
            start.setTime(d2);
        } else {
            start.setTime(d1);
            end.setTime(d2);
        }
        int diffDays = 0;
        do {
            start.add(5, 1);
            if (start.get(7) == 7 || start.get(7) == 1) continue;
            ++diffDays;
        } while (start.getTimeInMillis() < end.getTimeInMillis());
        return diffDays;
    }

    public static DateTime stringToDateTime(String stringDate) {
        DateTime date = null;
        try {
            date = DateTime.parse((String)stringDate, (DateTimeFormatter)DATETIME_FORMAT);
        }
        catch (Exception e) {
            try {
                date = DateTime.parse((String)stringDate, (DateTimeFormatter)DATETIME_2_FORMAT);
            }
            catch (Exception e2) {
                try {
                    date = DateTime.parse((String)stringDate, (DateTimeFormatter)DATETIME_3_FORMAT);
                }
                catch (Exception e3) {
                    return null;
                }
            }
        }
        return date;
    }

    public static DateTime stringToDateFormatTwo(String stringDate) {
        DateTime date = null;
        try {
            date = DateTime.parse((String)stringDate, (DateTimeFormatter)DATE_2_FORMAT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static Date ofShortDate2(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

