/*
 * Decompiled with CFR 0.152.
 */
package io.g740.client.util;

import io.g740.client.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;

public class ApiUtils {
    private static final String KEY_SPLITITOR = "#";
    public static final List<String> RESERVED_QUERY_PARAMETER_NAME_LIST = new ArrayList<String>(Arrays.asList("page", "size", "sort", "token", "apiKey", "sign", "t", "api_key", "timestamp", "nonce_str", "data_facet_key", "moreWhereClauses", "more_where_clauses"));
    public static final String RESERVED_QUERY_PARAMETER_NAME_REGEX_PATTERN = "^[a-zA-Z]{1}[a-zA-Z0-9_]*\\.dir$";

    private ApiUtils() {
    }

    public static Map<String, String[]> removeReservedParameters(Map<String, String[]> originalParameterMap) {
        HashMap<String, String[]> copyParameterMap = new HashMap<String, String[]>();
        for (Map.Entry<String, String[]> entry : originalParameterMap.entrySet()) {
            if (RESERVED_QUERY_PARAMETER_NAME_LIST.contains(entry.getKey()) || entry.getKey().matches(RESERVED_QUERY_PARAMETER_NAME_REGEX_PATTERN) || entry.getValue() == null || entry.getValue().length <= 0) continue;
            ArrayList<String> validValues = new ArrayList<String>();
            for (String value : entry.getValue()) {
                if (!StringUtils.isNotNullNorEmpty(value)) continue;
                validValues.add(value.trim());
            }
            if (validValues.size() <= 0) continue;
            String[] validValueArray = validValues.toArray(new String[validValues.size()]);
            copyParameterMap.put(entry.getKey(), validValueArray);
        }
        return copyParameterMap;
    }

    public static Map<String, String[]> restructurePage2Parameter(Map<String, String[]> requestParameterMap, Pageable pageable) {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        for (Map.Entry<String, String[]> entry : requestParameterMap.entrySet()) {
            parameterMap.put(entry.getKey(), entry.getValue());
        }
        long offset = pageable.getPageSize() * pageable.getPageNumber();
        int size = pageable.getPageSize();
        long page = offset / (long)size;
        parameterMap.put("page", new String[]{page + ""});
        parameterMap.put("size", new String[]{size + ""});
        return parameterMap;
    }

    public static Map<String, String[]> restructurePage2Parameter(Map<String, String[]> requestParameterMap) {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        if (!CollectionUtils.isEmpty(requestParameterMap)) {
            for (Map.Entry<String, String[]> entry : requestParameterMap.entrySet()) {
                parameterMap.put(entry.getKey(), entry.getValue());
            }
        }
        String[] page = (String[])parameterMap.get("page");
        String[] size = (String[])parameterMap.get("size");
        if (page == null || page.length == 0) {
            page = new String[]{"0"};
            parameterMap.put("page", page);
        }
        if (size == null || size.length == 0) {
            size = new String[]{"20"};
            parameterMap.put("size", size);
        }
        return parameterMap;
    }

    public static Map<String, String[]> restructureParameter(Map<String, String[]> requestParameterMap) {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        for (Map.Entry<String, String[]> entry : requestParameterMap.entrySet()) {
            parameterMap.put(entry.getKey(), entry.getValue());
        }
        return parameterMap;
    }
}

