/*
 * Decompiled with CFR 0.152.
 */
package io.g740.client.query.impl;

import io.g740.client.query.SQLExecutor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.MapHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class QuerySQLExecutor
implements SQLExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuerySQLExecutor.class);

    @Override
    public Map<String, Object> queryForMap(DataSource dataSource, String sql, List<Object> paramList) throws SQLException {
        Map result = null;
        QueryRunner queryRunner = new QueryRunner(dataSource);
        result = !CollectionUtils.isEmpty(paramList) ? (Map)queryRunner.query(sql, (ResultSetHandler)new MapHandler(), new Object[]{paramList}) : (Map)queryRunner.query(sql, (ResultSetHandler)new MapHandler());
        return result;
    }

    @Override
    public List<Map<String, Object>> queryForMapList(DataSource dataSource, String sql, List<Object> paramList) throws SQLException {
        List result = null;
        QueryRunner queryRunner = new QueryRunner(dataSource);
        result = !CollectionUtils.isEmpty(paramList) ? (List)queryRunner.query(sql, (ResultSetHandler)new MapListHandler(), new Object[]{paramList}) : (List)queryRunner.query(sql, (ResultSetHandler)new MapListHandler());
        return result;
    }

    @Override
    public T queryForObject(DataSource dataSource, String sql, List<Object> paramList, ResultSetHandler<T> resultSetHandler) throws SQLException {
        List<T> list = this.queryForObjectList(dataSource, sql, paramList, resultSetHandler);
        return list != null && !list.isEmpty() ? list.get(0) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> queryForObjectList(DataSource dataSource, String sql, List<Object> paramList, ResultSetHandler<T> resultSetHandler) throws SQLException {
        Connection conn = dataSource.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                stmt = conn.prepareStatement(sql);
                this.bindParameters(stmt, paramList);
                rs = stmt.executeQuery();
                ArrayList<T> list = new ArrayList<T>();
                if (rs != null) {
                    while (rs.next()) {
                        T t = (T)resultSetHandler.handle(rs);
                        list.add(t);
                    }
                }
                ArrayList<T> arrayList = list;
                this.closeConnection(conn, stmt, rs);
                return arrayList;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                this.closeConnection(conn, stmt, rs);
            }
        }
        return null;
    }

    private void bindParameters(PreparedStatement stmt, Object ... params) throws SQLException {
        for (int i = 0; i < params.length; ++i) {
            stmt.setObject(i + 1, params[i]);
        }
    }

    public void closeConnection(Connection conn, Statement stmt, ResultSet rs) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }
}

