/*
 * Decompiled with CFR 0.152.
 */
package io.g740.client.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.g740.client.dto.PageResultDTO;
import io.g740.client.dto.SQLGenerResultDTO;
import io.g740.client.entity.DataExportTaskDO;
import io.g740.client.service.DataExportService;
import io.g740.client.service.QueryDataSercive;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class D1ClientComponent {
    @Autowired
    DiscoveryClient discoveryClient;
    @Autowired
    private QueryDataSercive queryDataSercive;
    @Autowired
    private DataExportService dataExportService;
    @Value(value="${d1-core-service.url:}")
    private String hostAndPortUrl;
    private String formTableSettingForExportUrl = "/d1/export/form-table-setting";
    private String exportUpdateTaskUrl = "/d1/export/update-task";
    private String exportAddTaskUrl = "/d1/export/add-task";
    private String exportTaskStatusUrl = "/d1/export/task-status";
    private String formTableSettingUrl = "/d1/query-suite/general-sql";

    public String getHostAndPortUrl(String serviceId) throws Exception {
        if (StringUtils.isBlank((CharSequence)serviceId)) {
            String hostAndPort = this.hostAndPortUrl;
            System.out.println("hostAndPort>>>" + hostAndPort);
            if (StringUtils.isBlank((CharSequence)hostAndPort)) {
                throw new Exception("d1-core-service url can not be null");
            }
            return hostAndPort;
        }
        List instances = this.discoveryClient.getInstances(serviceId);
        if (CollectionUtils.isEmpty((Collection)instances)) {
            throw new Exception("serviceId is not found!");
        }
        ServiceInstance serviceInstance = (ServiceInstance)instances.get(0);
        String jsonString = JSONObject.toJSONString((Object)serviceInstance);
        JSONObject jsonObject = JSON.parseObject((String)jsonString);
        JSONObject instanceInfo = jsonObject.getJSONObject("instanceInfo");
        String host = instanceInfo.get((Object)"iPAddr") + "";
        System.out.println(host);
        int port = serviceInstance.getPort();
        String url = "http://" + host + ":" + port;
        return url;
    }

    public Long executeExportTask(String dataFacetKey, DataSource dataSource, String serviceId, String fileName, String fileTempPath, Map<String, String[]> restructureParameter) throws Exception {
        String hostAndPortUrl = this.getHostAndPortUrl(serviceId);
        return this.dataExportService.executeExportTask(dataFacetKey, dataSource, fileName, fileTempPath, hostAndPortUrl + this.exportAddTaskUrl, hostAndPortUrl + this.exportUpdateTaskUrl, hostAndPortUrl + this.formTableSettingUrl, hostAndPortUrl + this.formTableSettingForExportUrl, restructureParameter);
    }

    public DataExportTaskDO findDataExportTaskById(Long taskId, String serviceId) throws Exception {
        String hostAndPortUrl = this.getHostAndPortUrl(serviceId);
        String url = hostAndPortUrl + this.exportTaskStatusUrl;
        return this.dataExportService.findDataExportTaskById(taskId, url);
    }

    public void exportFileDownload(Long taskId, String serviceId, HttpServletResponse res) throws Exception {
        String hostAndPortUrl = this.getHostAndPortUrl(serviceId);
        String url = hostAndPortUrl + this.exportTaskStatusUrl;
        this.dataExportService.exportFileDownload(taskId, url, res);
    }

    public PageResultDTO executeQuery(String dataFacetKey, DataSource dataSource, boolean usePaging, String serviceId, Map<String, String[]> restructureParameter) throws Exception {
        String hostAndPortUrl = this.getHostAndPortUrl(serviceId);
        String url = hostAndPortUrl + this.formTableSettingUrl;
        return this.queryDataSercive.executeQuery(dataFacetKey, dataSource, usePaging, url, restructureParameter);
    }

    public SQLGenerResultDTO generalQuery(String dataFacetKey, Boolean usePaging, String serviceId, Map<String, String[]> requestParams) throws Exception {
        if (requestParams == null) {
            requestParams = new LinkedHashMap<String, String[]>();
        }
        requestParams.put("data_facet_key", new String[]{dataFacetKey});
        String hostAndPortUrl = this.getHostAndPortUrl(serviceId);
        String url = hostAndPortUrl + this.formTableSettingUrl;
        return this.queryDataSercive.generalQuery(dataFacetKey, usePaging, url, requestParams);
    }
}

