package io.g740.client.query;

import io.g740.client.query.impl.MySQLParamTransformer;
import io.g740.client.query.impl.OracleParamTransformer;
import io.g740.client.query.impl.PostgreSQLParamTransformer;
import io.g740.client.query.impl.SqlServerParamTransformer;
import org.springframework.stereotype.Component;

/**
 * @function:
 * @author: DAM
 * @date: 2019/7/30 19:17
 * @description:
 * @version: V1.0
 */
@Component
public class SQLParamTransformerFactory {
    private MySQLParamTransformer mySQLParamTransformer;
    private OracleParamTransformer oracleParamTransformer;
    private PostgreSQLParamTransformer postgreSQLParamTransformer;
    private SqlServerParamTransformer sqlServerParamTransformer;

    public SQLParamTransformer bulider(String sqlType){
        switch (sqlType) {
            case SQLType.SQL_TYPE_MYSQL:
                return this.getMySQLParamTransformer();
            case SQLType.SQL_TYPE_ORACLE:
                return this.getOracleParamTransformer();
            case SQLType.SQL_TYPE_POSTGRESQL:
                return this.getPostgreSQLParamTransformer();
            case SQLType.SQL_TYPE_SQLSERVER:
                return this.getSqlServerParamTransformer();
            default:
                return this.getMySQLParamTransformer();
        }
    }

    public MySQLParamTransformer getMySQLParamTransformer() {
        if(mySQLParamTransformer==null){
            mySQLParamTransformer=new MySQLParamTransformer();
        }
        return mySQLParamTransformer;
    }

    public OracleParamTransformer getOracleParamTransformer() {
        if(oracleParamTransformer==null){
            oracleParamTransformer=new OracleParamTransformer();
        }
        return oracleParamTransformer;
    }

    public PostgreSQLParamTransformer getPostgreSQLParamTransformer() {
        if(postgreSQLParamTransformer==null){
            postgreSQLParamTransformer=new PostgreSQLParamTransformer();
        }
        return postgreSQLParamTransformer;
    }

    public SqlServerParamTransformer getSqlServerParamTransformer() {
        if(sqlServerParamTransformer==null){
            sqlServerParamTransformer=new SqlServerParamTransformer();
        }
        return sqlServerParamTransformer;
    }

    public static class SQLType {
        final static String SQL_TYPE_MYSQL = "MYSQL";
        final static String SQL_TYPE_ORACLE = "ORACLE";
        final static String SQL_TYPE_SQLSERVER = "SQLSERVER";
        final static String SQL_TYPE_POSTGRESQL = "POSTGRESQL";
    }
}
