/*
 * Decompiled with CFR 0.152.
 */
package io.g740.client.service.impl;

import com.alibaba.fastjson.JSONObject;
import io.g740.client.dao.QueryDataDao;
import io.g740.client.dto.PageResultDTO;
import io.g740.client.dto.SQLGenerResultDTO;
import io.g740.client.query.SQLParamTransformerFactory;
import io.g740.client.service.QueryDataSercive;
import io.g740.client.util.ApiUtils;
import io.g740.client.util.HttpClientUtil;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryDataSerciveImpl
implements QueryDataSercive {
    @Autowired
    private QueryDataDao queryDataDao;
    @Autowired
    private SQLParamTransformerFactory sqlParamTransformerFactory;

    @Override
    public PageResultDTO executeQuery(String dataFacetKey, DataSource datasource, Boolean usePaging, String formTableSettingUrl, Map<String, String[]> requestParams) throws Exception {
        if (StringUtils.isBlank((CharSequence)dataFacetKey)) {
            throw new Exception("Empty data source key " + dataFacetKey);
        }
        SQLGenerResultDTO sqlGenerResultDTO = this.generalQuery(dataFacetKey, usePaging, formTableSettingUrl, requestParams);
        if (sqlGenerResultDTO == null) {
            throw new Exception(String.format("please check url or params![s%]", dataFacetKey));
        }
        return this.queryDataDao.excuteQuery(sqlGenerResultDTO, datasource);
    }

    @Override
    public SQLGenerResultDTO generalQuery(String dataFacetKey, Boolean usePaging, String formTableSettingUrl, Map<String, String[]> requestParams) throws Exception {
        if (StringUtils.isBlank((CharSequence)dataFacetKey)) {
            throw new Exception("Empty data source key " + dataFacetKey);
        }
        Map<String, String[]> simpleParameters = null;
        String url = formTableSettingUrl;
        simpleParameters = usePaging != false ? ApiUtils.restructurePage2Parameter(requestParams) : ApiUtils.restructureParameter(requestParams);
        String result = HttpClientUtil.doGet(url, simpleParameters);
        SQLGenerResultDTO sqlGenerResultDTO = (SQLGenerResultDTO)JSONObject.parseObject((String)result, SQLGenerResultDTO.class);
        if (sqlGenerResultDTO == null) {
            throw new Exception("response result happened error!");
        }
        List<Object> transformParamsList = this.sqlParamTransformerFactory.bulider(sqlGenerResultDTO.getSqlType()).transform(sqlGenerResultDTO.getParamsValue(), sqlGenerResultDTO.getParamsType());
        sqlGenerResultDTO.setParamsValue(transformParamsList);
        return sqlGenerResultDTO;
    }
}

