/*
 * Decompiled with CFR 0.152.
 */
package io.g740.client.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.g740.client.dto.SQLGenerResultDTO;
import io.g740.client.entity.DataExportTaskDO;
import io.g740.client.entity.DfFormTableSettingDO;
import io.g740.client.executor.Executor;
import io.g740.client.executor.impl.CommonExportExecutor;
import io.g740.client.executor.impl.ExecutorBuilder;
import io.g740.client.service.DataExportService;
import io.g740.client.service.QueryDataSercive;
import io.g740.client.util.DateUtils;
import io.g740.client.util.FileUtils;
import io.g740.client.util.HttpClientUtil;
import io.g740.client.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataExportServiceImpl
implements DataExportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataExportServiceImpl.class);
    private ExecutorService executorService = Executors.newFixedThreadPool(1);
    @Autowired
    private QueryDataSercive queryDataSercive;

    @Override
    public DataExportTaskDO findDataExportTaskById(Long taskId, String url) throws Exception {
        HashMap<String, String[]> simpleParameters = new HashMap<String, String[]>();
        simpleParameters.put("taskId", new String[]{taskId + ""});
        String result = HttpClientUtil.doGet(url, simpleParameters);
        DataExportTaskDO dataExportTaskDO = (DataExportTaskDO)JSONObject.parseObject((String)result, DataExportTaskDO.class);
        return dataExportTaskDO;
    }

    @Override
    public DataExportTaskDO addDataExportTask(DataExportTaskDO dataExportTask, String exportAddTaskUrl) throws Exception {
        String jsonParams = this.getJsonString(dataExportTask);
        String result = HttpClientUtil.doPostJson(exportAddTaskUrl, jsonParams, null);
        DataExportTaskDO dataExportTaskDO = (DataExportTaskDO)JSONObject.parseObject((String)result, DataExportTaskDO.class);
        return dataExportTaskDO;
    }

    @Override
    public DataExportTaskDO updateDataExportTask(DataExportTaskDO dataExportTaskDO, String exportUpdateTaskUrl) throws Exception {
        String jsonParams = this.getJsonString(dataExportTaskDO);
        String result = HttpClientUtil.doPostJson(exportUpdateTaskUrl, jsonParams, null);
        DataExportTaskDO dataExportTask = (DataExportTaskDO)JSONObject.parseObject((String)result, DataExportTaskDO.class);
        return dataExportTask;
    }

    @Override
    public List<DfFormTableSettingDO> getAllDsFormTableSettingByDfKeyForExport(String dataFacetKey, String url) {
        HashMap<String, String[]> simpleParameters = new HashMap<String, String[]>();
        simpleParameters.put("data_facet_key", new String[]{dataFacetKey});
        String result = HttpClientUtil.doGet(url, simpleParameters);
        List DfFormTableSettingDOS = JSONObject.parseArray((String)result, DfFormTableSettingDO.class);
        return DfFormTableSettingDOS;
    }

    @Override
    public Long executeExportTask(final String dataFacetKey, final DataSource dataSource, String fileName, final String fileTempPath, String exportAddTaskUrl, final String exportUpdateTaskUrl, final String formTableSettingUrl, final String formTableSettingForExportUrl, final Map<String, String[]> requestParams) throws Exception {
        if (StringUtils.isNullOrEmpty(dataFacetKey)) {
            throw new Exception("Empty data source key " + dataFacetKey);
        }
        final DataExportTaskDO dataExportTask = new DataExportTaskDO();
        String now = DateUtils.ofLongStr(new Date());
        dataExportTask.setStartAt(now);
        dataExportTask.setFileName(fileName);
        long start = System.currentTimeMillis();
        LOGGER.info("async export \u5f00\u59cb\u8c03\u7528data export task");
        final DataExportTaskDO toWaitSaveExportTask = this.addDataExportTask(dataExportTask, exportAddTaskUrl);
        LOGGER.info("async export \u5f00\u59cb\u8c03\u7528data export task:{}", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    File exportFile = DataExportServiceImpl.this.export(dataFacetKey, dataSource, fileTempPath, formTableSettingUrl, formTableSettingForExportUrl, dataExportTask, requestParams);
                    toWaitSaveExportTask.setFileName(exportFile.getName());
                    toWaitSaveExportTask.setFilePath(exportFile.getAbsolutePath());
                    toWaitSaveExportTask.setEndAt(DateUtils.ofLongStr(new Date()));
                    DataExportServiceImpl.this.updateDataExportTask(toWaitSaveExportTask, exportUpdateTaskUrl);
                }
                catch (Exception e) {
                    LOGGER.error("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25,id: {}", (Object)dataExportTask.getId(), (Object)e);
                    toWaitSaveExportTask.setFailedAt(DateUtils.ofLongStr(new Date()));
                    toWaitSaveExportTask.setDetails(e.getMessage());
                    try {
                        DataExportServiceImpl.this.updateDataExportTask(toWaitSaveExportTask, exportUpdateTaskUrl);
                    }
                    catch (Exception e1) {
                        LOGGER.info("Save user export task failure");
                    }
                }
            }
        });
        return toWaitSaveExportTask.getId();
    }

    @Override
    public File export(String dataFacetKey, DataSource dataSource, String fileTempPath, String formTableSettingUrl, String formTableSettingForExportUrl, DataExportTaskDO dataExportTaskDO, Map<String, String[]> requestParams) throws Exception {
        SQLGenerResultDTO sqlGenerResultDTO;
        String fileName = dataExportTaskDO.getFileName();
        String fullFilePathOfExportFile = FileUtils.contact(fileTempPath, fileName);
        File tmpFile = new File(fullFilePathOfExportFile);
        File parentFile = tmpFile.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        if ((sqlGenerResultDTO = this.queryDataSercive.generalQuery(dataFacetKey, false, formTableSettingUrl, requestParams)) == null) {
            throw new Exception("get general sql failed");
        }
        List<DfFormTableSettingDO> queryTableSettings = this.getAllDsFormTableSettingByDfKeyForExport(dataFacetKey, formTableSettingForExportUrl);
        String querySql = sqlGenerResultDTO.getQuerySql();
        List<Object> paramList = sqlGenerResultDTO.getParamsValue();
        Executor build = ExecutorBuilder.getInstance().dataSource(dataSource).exportExecutor(new CommonExportExecutor()).build();
        return build.exportExcel(querySql, paramList, queryTableSettings, Paths.get(fullFilePathOfExportFile, new String[0]));
    }

    private String getJsonString(Object o) {
        SerializeConfig config = new SerializeConfig();
        config.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
        return JSON.toJSONString((Object)o, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportFileDownload(Long taskId, String exportTaskStatusUrl, HttpServletResponse response) throws Exception {
        DataExportTaskDO dataExportTaskDO = this.findDataExportTaskById(taskId, exportTaskStatusUrl);
        if (dataExportTaskDO == null) {
            throw new Exception("taskId is not found");
        }
        if (StringUtils.isNotNullNorEmpty(dataExportTaskDO.getFailedAt()) || StringUtils.isNullOrEmpty(dataExportTaskDO.getFilePath())) {
            throw new Exception("export file is failed");
        }
        String filePath = dataExportTaskDO.getFilePath();
        File file = new File(filePath);
        response.setCharacterEncoding("UTF-8");
        response.setHeader("content-type", "application/octet-stream;charset=UTF-8");
        response.setContentType("application/octet-stream;charset=UTF-8");
        response.addHeader("Content-Length", String.valueOf(new FileInputStream(file).available()));
        try {
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(file.getName(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("error:" + e);
        }
        byte[] buff = new byte[1024];
        BufferedInputStream bis = null;
        ServletOutputStream os = null;
        try {
            os = response.getOutputStream();
            bis = new BufferedInputStream(new FileInputStream(file));
            int i = bis.read(buff);
            while (i != -1) {
                os.write(buff, 0, buff.length);
                os.flush();
                i = bis.read(buff);
            }
            LOGGER.info("\u4e0b\u8f7d\u6210\u529f,filePath=", (Object)filePath);
        }
        catch (IOException e) {
            LOGGER.error("\u4e0b\u8f7d\u5931\u8d25,filePath={}", (Object)filePath);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    LOGGER.error("error:", (Throwable)e);
                }
            }
            if (os != null) {
                try {
                    os.close();
                    os.flush();
                }
                catch (IOException e) {
                    LOGGER.error("error:", (Throwable)e);
                }
            }
        }
    }
}

