/*
 * Decompiled with CFR 0.152.
 */
package io.g740.client.query;

import io.g740.client.query.SQLParamTransformer;
import io.g740.client.query.impl.MySQLParamTransformer;
import io.g740.client.query.impl.OracleParamTransformer;
import io.g740.client.query.impl.PostgreSQLParamTransformer;
import io.g740.client.query.impl.SqlServerParamTransformer;
import org.springframework.stereotype.Component;

@Component
public class SQLParamTransformerFactory {
    private MySQLParamTransformer mySQLParamTransformer;
    private OracleParamTransformer oracleParamTransformer;
    private PostgreSQLParamTransformer postgreSQLParamTransformer;
    private SqlServerParamTransformer sqlServerParamTransformer;

    public SQLParamTransformer bulider(String sqlType) {
        switch (sqlType) {
            case "MYSQL": {
                return this.getMySQLParamTransformer();
            }
            case "ORACLE": {
                return this.getOracleParamTransformer();
            }
            case "POSTGRESQL": {
                return this.getPostgreSQLParamTransformer();
            }
            case "SQLSERVER": {
                return this.getSqlServerParamTransformer();
            }
        }
        return this.getMySQLParamTransformer();
    }

    public MySQLParamTransformer getMySQLParamTransformer() {
        if (this.mySQLParamTransformer == null) {
            this.mySQLParamTransformer = new MySQLParamTransformer();
        }
        return this.mySQLParamTransformer;
    }

    public OracleParamTransformer getOracleParamTransformer() {
        if (this.oracleParamTransformer == null) {
            this.oracleParamTransformer = new OracleParamTransformer();
        }
        return this.oracleParamTransformer;
    }

    public PostgreSQLParamTransformer getPostgreSQLParamTransformer() {
        if (this.postgreSQLParamTransformer == null) {
            this.postgreSQLParamTransformer = new PostgreSQLParamTransformer();
        }
        return this.postgreSQLParamTransformer;
    }

    public SqlServerParamTransformer getSqlServerParamTransformer() {
        if (this.sqlServerParamTransformer == null) {
            this.sqlServerParamTransformer = new SqlServerParamTransformer();
        }
        return this.sqlServerParamTransformer;
    }

    public static class SQLType {
        static final String SQL_TYPE_MYSQL = "MYSQL";
        static final String SQL_TYPE_ORACLE = "ORACLE";
        static final String SQL_TYPE_SQLSERVER = "SQLSERVER";
        static final String SQL_TYPE_POSTGRESQL = "POSTGRESQL";
    }
}

