/*
 * Decompiled with CFR 0.152.
 */
package io.g740.client.poi;

import io.g740.client.poi.RowUnit;
import io.g740.client.poi.RowUnitConverter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonExcelWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonExcelWriter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wirteCommonData(OutputStream outputStream, String[] headers, String sheetName, Integer[] cellWidths, RowUnitConverter converter) {
        SXSSFWorkbook workbook = new SXSSFWorkbook(1000);
        CellStyle cellStyle = CommonExcelWriter.applyContentRowStyle((Workbook)workbook);
        Iterable<RowUnit> cellUnitIterable = converter.convert();
        if (cellUnitIterable == null) {
            return;
        }
        Iterator<RowUnit> iterator = cellUnitIterable.iterator();
        int count = 0;
        Sheet sheet = null;
        while (iterator.hasNext()) {
            RowUnit rowUnit = iterator.next();
            int pageIndex = count / 65535;
            int rowSize = count % 65535;
            if (rowSize == 0 || sheet == null) {
                sheet = CommonExcelWriter.createSheet((Workbook)workbook, sheetName, pageIndex + 1, headers, cellWidths);
            }
            if (sheet != null) {
                Row row = sheet.createRow(rowUnit.getRowIndex().intValue());
                List<String> cellValues = rowUnit.getCellValues();
                if (cellValues == null) {
                    return;
                }
                for (int i = 0; i < cellValues.size(); ++i) {
                    CommonExcelWriter.fillCellToRow(row, i, cellValues.get(i), cellStyle);
                }
            }
            ++count;
        }
        try {
            if (count > 0) {
                workbook.write(outputStream);
            }
        }
        catch (IOException e) {
            LOGGER.error("write excel failed", (Throwable)e);
        }
        finally {
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException e) {
                LOGGER.error("OutputStream Close Failed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendCommonData(OutputStream outputStream, String[] headers, Integer[] cellWidths, String sheetName, RowUnitConverter converter) {
        Iterable<RowUnit> cellUnitIterable = converter.convert();
        if (cellUnitIterable == null) {
            return;
        }
        SXSSFWorkbook workbook = new SXSSFWorkbook(1000);
        CellStyle cellStyle = CommonExcelWriter.applyContentRowStyle((Workbook)workbook);
        int numberOfSheets = workbook.getNumberOfSheets();
        Sheet sheet = null;
        if (numberOfSheets <= 0) {
            sheet = CommonExcelWriter.createSheet((Workbook)workbook, sheetName, 0, headers, cellWidths);
        }
        int activeSheetIndex = workbook.getActiveSheetIndex();
        sheet = workbook.getSheetAt(activeSheetIndex);
        Iterator<RowUnit> iterator = cellUnitIterable.iterator();
        if (sheet == null) {
            sheet = CommonExcelWriter.createSheet((Workbook)workbook, sheetName, activeSheetIndex, headers, cellWidths);
        }
        int currentRowNum = sheet.getLastRowNum();
        while (iterator.hasNext()) {
            RowUnit rowUnit = iterator.next();
            if (currentRowNum >= 1000000) {
                sheet = CommonExcelWriter.createSheet((Workbook)workbook, sheetName, ++activeSheetIndex, headers, cellWidths);
                currentRowNum = 0;
            }
            if (sheet != null) {
                Row row = null;
                row = headers == null || headers.length <= 0 ? sheet.createRow(rowUnit.getRowIndex().intValue()) : sheet.createRow(rowUnit.getRowIndex() + 1);
                List<String> cellValues = rowUnit.getCellValues();
                if (cellValues == null) {
                    return;
                }
                for (int i = 0; i < cellValues.size(); ++i) {
                    CommonExcelWriter.fillCellToRow(row, i, cellValues.get(i), cellStyle);
                }
            }
            ++currentRowNum;
        }
        try {
            workbook.write(outputStream);
        }
        catch (IOException e) {
            LOGGER.error("write excel failed", (Throwable)e);
        }
        finally {
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException e) {
                LOGGER.error("OutputStream Close Failed");
            }
        }
    }

    private static Sheet createSheet(Workbook workbook, String sheetName, Integer index, String[] headers, Integer[] cellWidths) {
        if (sheetName == null || sheetName.isEmpty()) {
            sheetName = "Sheet";
        }
        Sheet sheet = workbook.createSheet(sheetName + index);
        sheet.setDefaultColumnWidth(20);
        for (int i = 0; i < cellWidths.length; ++i) {
            sheet.setColumnWidth(i, cellWidths[i] * 256);
        }
        if (headers != null && headers.length > 0) {
            Row row = sheet.createRow(0);
            CellStyle cellStyle = CommonExcelWriter.applyTitleRowStyle(workbook);
            for (int i = 0; i < headers.length; ++i) {
                CommonExcelWriter.fillCellToRow(row, i, headers[i], cellStyle);
            }
        }
        workbook.setActiveSheet(index.intValue());
        return sheet;
    }

    private static void fillCellToRow(Row row, int column, String value, CellStyle cellStyle) {
        Cell cell = row.createCell(column);
        cell.setCellValue(value);
        cell.setCellStyle(cellStyle);
    }

    private static CellStyle applyTitleRowStyle(Workbook workbook) {
        CellStyle titleRowStyle = workbook.createCellStyle();
        titleRowStyle.setFillForegroundColor((short)40);
        titleRowStyle.setFillPattern((short)1);
        titleRowStyle.setBorderBottom((short)1);
        titleRowStyle.setBorderLeft((short)1);
        titleRowStyle.setBorderRight((short)1);
        titleRowStyle.setBorderTop((short)1);
        titleRowStyle.setAlignment((short)2);
        titleRowStyle.setVerticalAlignment((short)1);
        Font titleRowFont = workbook.createFont();
        titleRowFont.setColor((short)20);
        titleRowFont.setFontHeightInPoints((short)12);
        titleRowFont.setBoldweight((short)700);
        titleRowStyle.setFont(titleRowFont);
        return titleRowStyle;
    }

    private static CellStyle applyContentRowStyle(Workbook workbook) {
        CellStyle contentRowStyle = workbook.createCellStyle();
        contentRowStyle.setFillForegroundColor((short)9);
        contentRowStyle.setFillPattern((short)1);
        contentRowStyle.setBorderBottom((short)1);
        contentRowStyle.setBorderLeft((short)1);
        contentRowStyle.setBorderRight((short)1);
        contentRowStyle.setBorderTop((short)1);
        contentRowStyle.setAlignment((short)2);
        contentRowStyle.setVerticalAlignment((short)1);
        Font contentRowFont = workbook.createFont();
        contentRowFont.setFontHeightInPoints((short)10);
        contentRowStyle.setFont(contentRowFont);
        return contentRowStyle;
    }
}

