/*
 * Decompiled with CFR 0.152.
 */
package io.g740.client.executor.impl;

import io.g740.client.executor.Executor;
import io.g740.client.executor.ExportExecutor;
import io.g740.client.executor.impl.CommonExecutor;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutorBuilder.class);
    private DataSource dataSource;
    private ExportExecutor exportExecutor;

    public static ExecutorBuilder getInstance() {
        return new ExecutorBuilder();
    }

    public ExecutorBuilder dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public ExecutorBuilder exportExecutor(ExportExecutor exportExecutor) {
        this.exportExecutor = exportExecutor;
        return this;
    }

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    protected ExportExecutor getExportExecutor() {
        return this.exportExecutor;
    }

    public Executor build() {
        return new CommonExecutor(this);
    }
}

