/*
 * Decompiled with CFR 0.152.
 */
package io.g740.client.executor.impl;

import io.g740.client.entity.DfFormTableSettingDO;
import io.g740.client.executor.ExportExecutor;
import io.g740.client.poi.CommonExcelWriter;
import io.g740.client.poi.RowUnit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class CommonExportExecutor
implements ExportExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonExportExecutor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File exportExcel(DataSource dataSource, String querySql, List<Object> paramList, List<DfFormTableSettingDO> queryTableSettings, Path path) {
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        File file = null;
        try {
            List fieldKeyList = queryTableSettings.stream().sorted(Comparator.comparing(DfFormTableSettingDO::getExportFieldSequence)).map(DfFormTableSettingDO::getDbFieldName).collect(Collectors.toList());
            List<String> fieldAliasLabelList = queryTableSettings.stream().sorted(Comparator.comparing(DfFormTableSettingDO::getExportFieldSequence)).map(DfFormTableSettingDO::getViewFieldLabel).collect(Collectors.toList());
            for (DfFormTableSettingDO e : queryTableSettings) {
                if (e.getExportFieldWidth() != null && e.getExportFieldWidth() > 0) continue;
                e.setExportFieldWidth(15);
            }
            List<Integer> fieldAliasLabelWidth = queryTableSettings.stream().sorted(Comparator.comparing(DfFormTableSettingDO::getExportFieldSequence)).map(DfFormTableSettingDO::getExportFieldWidth).collect(Collectors.toList());
            String filePath = path.toString();
            file = new File(filePath);
            connection = dataSource.getConnection();
            preparedStatement = connection.prepareStatement(querySql);
            if (!CollectionUtils.isEmpty(paramList)) {
                this.bindParameters((PreparedStatement)preparedStatement, paramList.toArray());
            }
            preparedStatement.setQueryTimeout(3600);
            resultSet = preparedStatement.executeQuery();
            ArrayList<Map<String, String>> cacheRowMapList = new ArrayList<Map<String, String>>();
            while (resultSet.next()) {
                LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>();
                for (String fieldKey : fieldKeyList) {
                    try {
                        String value = resultSet.getString(fieldKey);
                        rowMap.put(fieldKey, value);
                    }
                    catch (Exception e) {
                        rowMap.put(fieldKey, null);
                    }
                }
                cacheRowMapList.add(rowMap);
            }
            if (cacheRowMapList.size() > 0) {
                this.write2Excel(cacheRowMapList, queryTableSettings, file, fieldAliasLabelList, fieldAliasLabelWidth);
                cacheRowMapList.clear();
            }
        }
        catch (SQLException e) {
            LOGGER.error("", (Throwable)e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
        }
        return file;
    }

    private void bindParameters(PreparedStatement stmt, Object ... params) throws SQLException {
        for (int i = 0; i < params.length; ++i) {
            stmt.setObject(i + 1, params[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write2Excel(List<Map<String, String>> cacheRowMapList, List<DfFormTableSettingDO> queryTableSettings, File file, List<String> fieldAliasLabelList, List<Integer> fieldAliasLabelWidth) {
        if (queryTableSettings != null && cacheRowMapList != null && !cacheRowMapList.isEmpty()) {
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(file);
                CommonExcelWriter.appendCommonData(outputStream, fieldAliasLabelList.toArray(new String[0]), fieldAliasLabelWidth.toArray(new Integer[0]), null, () -> {
                    ArrayList<RowUnit> rowUnits = new ArrayList<RowUnit>();
                    for (int i = 0; i < cacheRowMapList.size(); ++i) {
                        Map rowMap = (Map)cacheRowMapList.get(i);
                        RowUnit rowUnit = new RowUnit();
                        ArrayList<String> values = new ArrayList<String>(rowMap.values());
                        rowUnit.setRowIndex(i);
                        rowUnit.setCellValues(values);
                        rowUnits.add(rowUnit);
                    }
                    return rowUnits;
                });
            }
            catch (FileNotFoundException e) {
                LOGGER.error("", (Throwable)e);
            }
            finally {
                if (outputStream != null) {
                    try {
                        ((OutputStream)outputStream).close();
                    }
                    catch (IOException e) {
                        LOGGER.error("", (Throwable)e);
                    }
                }
            }
        }
    }
}

