package io.g740.client.service.impl;

import io.g740.client.dto.SQLGenerResultDTO;
import io.g740.client.query.SQLParamTransformerFactory;
import io.g740.client.util.ApiUtils;
import io.g740.client.util.HttpClientUtil;
import io.g740.client.dao.QueryDataDao;
import io.g740.client.dto.PageResultDTO;
import io.g740.client.service.QueryDataSercive;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.sql.DataSource;
import java.util.List;
import java.util.Map;

/**
 * @function:
 * @author: DAM
 * @date: 2019/7/15 16:44
 * @description:
 * @version: V1.0
 */
@Service
public class QueryDataSerciveImpl implements QueryDataSercive {


    @Autowired
    private QueryDataDao queryDataDao;

    @Autowired
    private SQLParamTransformerFactory sqlParamTransformerFactory;


    @Override
    public PageResultDTO executeQuery(String dataFacetKey,
                                      DataSource datasource,
                                      Boolean usePaging,
                                      String formTableSettingUrl,
                                      Map<String, String[]> requestParams) throws Exception {
        if (StringUtils.isBlank(dataFacetKey)) {
            throw new Exception("Empty data source key " + dataFacetKey);
        }
        //获取翻译好的sql语句
        SQLGenerResultDTO sqlGenerResultDTO = generalQuery(dataFacetKey, usePaging, formTableSettingUrl, requestParams);
        if (sqlGenerResultDTO == null) {
            throw new Exception(String.format("please check url or params![s%]", dataFacetKey));
        }

        return queryDataDao.excuteQuery(sqlGenerResultDTO, datasource);
    }


    @Override
    public SQLGenerResultDTO generalQuery(String dataFacetKey,
                                          Boolean usePaging,
                                          String formTableSettingUrl,
                                          Map<String, String[]> requestParams) throws Exception {
        if (StringUtils.isBlank(dataFacetKey)) {
            throw new Exception("Empty data source key " + dataFacetKey);
        }
        //分页处理，发送http请求
        Map<String, String[]> simpleParameters = null;
        if (usePaging) {
            simpleParameters = ApiUtils.restructurePage2Parameter(requestParams);
        } else {
            simpleParameters = ApiUtils.restructureParameter(requestParams);
        }
        String url = formTableSettingUrl;
        String result = HttpClientUtil.doGet(url, simpleParameters);
        SQLGenerResultDTO sqlGenerResultDTO = JSONObject.parseObject(result, SQLGenerResultDTO.class);
        if (sqlGenerResultDTO == null) {
            throw new Exception("response result happened error!");

        }
        //转成参数类型
        List<Object> transformParamsList = sqlParamTransformerFactory.bulider(sqlGenerResultDTO.getSqlType())
                .transform(sqlGenerResultDTO.getParamsValue(), sqlGenerResultDTO.getParamsType());

        sqlGenerResultDTO.setParamsValue(transformParamsList);
        return sqlGenerResultDTO;
    }


}
