package io.g740.client.service;

import io.g740.client.entity.DataExportTaskDO;
import io.g740.client.entity.DfFormTableSettingDO;

import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import java.io.File;
import java.util.List;
import java.util.Map;

/**
 * @function:
 * @author: DAM
 * @date: 2019/7/9 16:02
 * @description:
 * @version: V1.0
 */
public interface DataExportService {

    DataExportTaskDO findDataExportTaskById(Long taskId, String exportTaskStatusUrl)throws Exception;

    DataExportTaskDO addDataExportTask(DataExportTaskDO dataExportTask,String exportAddTaskUrl) throws Exception;

    DataExportTaskDO updateDataExportTask(DataExportTaskDO dataExportTaskDO,String exportUpdateTaskUrl) throws Exception;

    List<DfFormTableSettingDO> getAllDsFormTableSettingByDfKeyForExport(String dataFacetKey,String url);

    Long executeExportTask(String dataFacetKey,
                           DataSource dataSource,
                           String fileName,
                           String fileTempPath,
                           String exportAddTaskUrl,
                           String exportUpdateTaskUrl,
                           String formTableSettingUrl,
                           String formTableSettingForExportUrl,
                           Map<String, String[]> requestParams) throws Exception;

    File export(String dataFacetKey,
                DataSource dataSource,
                String fileTempPath,
                String formTableSettingUrl,
                String formTableSettingForExportUrl,
                DataExportTaskDO dataExportTaskDO,
                Map<String, String[]> requestParams) throws Exception;

    void exportFileDownload(Long taskId, String exportTaskStatusUrl, HttpServletResponse response) throws Exception;
}
