package io.g740.client.query.impl;

import io.g740.client.query.SQLExecutor;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.MapHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.sql.DataSource;
import java.sql.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @function:
 * @author: DAM
 * @date: 2019/7/29 17:27
 * @description:
 * @version: V1.0
 */
@Service
public class QuerySQLExecutor implements SQLExecutor {

    private final static Logger LOGGER=LoggerFactory.getLogger(QuerySQLExecutor.class);

    @Override
    public Map<String, Object> queryForMap(DataSource dataSource, String sql, List<Object> paramList) throws SQLException {
        Map<String, Object> result = null;
        QueryRunner queryRunner = new QueryRunner(dataSource);
        if (!CollectionUtils.isEmpty(paramList)) {
            result = queryRunner.query(sql, new MapHandler(), paramList);
        } else {
            result = queryRunner.query(sql, new MapHandler());
        }
        return result;
    }


    @Override
    public List<Map<String, Object>> queryForMapList(DataSource dataSource, String sql, List<Object> paramList) throws SQLException {
        List<Map<String, Object>> result = null;
        QueryRunner queryRunner = new QueryRunner(dataSource);
        if (!CollectionUtils.isEmpty(paramList)) {
            result = queryRunner.query(sql, new MapListHandler(), paramList);
        } else {
            result = queryRunner.query(sql, new MapListHandler());
        }
        return result;

    }

    @Override
    public T queryForObject(DataSource dataSource, String sql, List<Object> paramList, ResultSetHandler<T> resultSetHandler) throws SQLException {
        List<T> list = this.queryForObjectList(dataSource,sql, paramList,resultSetHandler);
        return list != null && !list.isEmpty() ? list.get(0) : null;
    }


    @Override
    public List<T> queryForObjectList(DataSource dataSource, String sql, List<Object> paramList, ResultSetHandler<T> resultSetHandler) throws SQLException {
        Connection conn=dataSource.getConnection();
        PreparedStatement stmt=null;
        ResultSet rs=null;
        if(conn!=null){
            try {
                stmt=conn.prepareStatement(sql);
                //绑定参数
                bindParameters(stmt, paramList);
                rs=stmt.executeQuery();
                List<T> list=new ArrayList<T>();
                if(rs!=null){
                    while(rs.next()){
                        T t=resultSetHandler.handle(rs);
                        list.add(t);
                    }
                }
                return list;
            } catch (SQLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }finally {
                closeConnection(conn, stmt, rs);
            }
        }
        return null;
    }

    /**
     * 绑定参数方法
     * @param stmt
     * @param params
     * @throws SQLException
     */
    private void bindParameters(PreparedStatement stmt, Object... params) throws SQLException {
        //绑定参数
        for(int i=0;i<params.length;i++){
            stmt.setObject(i+1, params[i]);
        }
    }

    /**
     * 关闭连接，释放资源
     *
     */
    public void closeConnection(Connection conn, Statement stmt, ResultSet rs) {
        if (conn != null) {
            try {
                conn.close();
            } catch (SQLException e) {
                LOGGER.error("",e);
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            } catch (SQLException e) {
                LOGGER.error("",e);
            }

        }
        if (rs != null) {
            try {
                rs.close();
            } catch (SQLException e) {
                LOGGER.error("",e);
            }
        }
    }
}
