/*
 * Decompiled with CFR 0.152.
 */
package io.g740.client.util;

import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.function.Function;

public class StringUtils {
    private static final String INTEGER_REGEX_PATTERN = "^-?[0-9]\\d*$";
    private static final String NUMBER_REGEX_PATTERN = "^[0-9]+\\.?[0-9]*$";
    private static final String DATE_REGEX_PATTERN = "^([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8])))$";

    private StringUtils() {
    }

    public static boolean isNotNullNorEmpty(String source) {
        if (source == null) {
            return false;
        }
        return !source.trim().isEmpty();
    }

    public static boolean isNullOrEmpty(String source) {
        if (source == null) {
            return true;
        }
        return source.trim().isEmpty();
    }

    public static boolean isInteger(String source) {
        return source.matches(INTEGER_REGEX_PATTERN);
    }

    public static boolean isNumber(String source) {
        if (StringUtils.isNotNullNorEmpty(source)) {
            return source.matches(NUMBER_REGEX_PATTERN);
        }
        return false;
    }

    public static boolean isDate(String source) {
        return source.matches(DATE_REGEX_PATTERN);
    }

    public static String camelToUnderline(String source) {
        StringBuilder dest = new StringBuilder();
        for (int i = 0; i < source.length(); ++i) {
            char ch = source.charAt(i);
            if (ch >= 'A' && ch <= 'Z') {
                if (i == 0) {
                    dest.append(String.valueOf(ch));
                    continue;
                }
                char previousCh = source.charAt(i - 1);
                if (previousCh >= 'A' && previousCh <= 'Z') {
                    dest.append(String.valueOf(ch));
                    continue;
                }
                dest.append('_' + String.valueOf(ch));
                continue;
            }
            dest.append(String.valueOf(ch));
        }
        return dest.toString().toLowerCase();
    }

    public static String object2String(Object object) {
        if (object == null) {
            return "";
        }
        return String.valueOf(object);
    }

    public static String object2StringWithDefault(Object object, String defaultValue) {
        if (object == null) {
            return defaultValue;
        }
        return String.valueOf(object);
    }

    public static <T> String collection2StringWithComma(Collection<T> collection, Function<T, String> toStringFunction) {
        if (collection.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        collection.stream().forEachOrdered(tmp -> sb.append((String)toStringFunction.apply(tmp)).append(","));
        return sb.substring(0, sb.length() - 1);
    }

    public static String removeNonPrintableCharactersFromStartAndEnd(String source) {
        char element;
        int end;
        char element2;
        int start;
        if (StringUtils.isNullOrEmpty(source)) {
            return source;
        }
        source = StringUtils.removeWhitespaceCharactersFromStartAndEnd(source);
        char[] elements = source.toCharArray();
        for (start = 0; start < elements.length && (Character.isSpaceChar(element2 = elements[start]) || !Character.isDefined(element2)); ++start) {
        }
        for (end = elements.length - 1; end >= start && (Character.isSpaceChar(element = elements[end]) || !Character.isDefined(element)); --end) {
        }
        return source.substring(start, end + 1);
    }

    public static String removeWhitespaceCharactersFromStartAndEnd(String source) {
        char element;
        int end;
        char element2;
        int start;
        if (StringUtils.isNullOrEmpty(source)) {
            return source;
        }
        source = source.trim();
        char[] elements = source.toCharArray();
        for (start = 0; start < elements.length && Character.toString(element2 = elements[start]).matches("\\s+"); ++start) {
        }
        for (end = elements.length - 1; end >= start && Character.toString(element = elements[end]).matches("\\s+"); --end) {
        }
        return source.substring(start, end + 1);
    }

    public static String splitMd5ResultLikeUUID(String md5Str) {
        StringBuilder sb = new StringBuilder(md5Str);
        sb.insert(8, "-");
        sb.insert(13, "-");
        sb.insert(18, "-");
        sb.insert(23, "-");
        return sb.toString();
    }

    public static Date long2Date(Object object) {
        return Optional.ofNullable(object).map(Object::toString).map(Long::valueOf).map(Date::new).orElse(null);
    }
}

