/*
 * Decompiled with CFR 0.152.
 */
package io.g740.client.util;

import java.util.Map;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class ParameterHandlerUtils {
    public static Pageable extractPageable(Map<String, String[]> params) {
        String[] pages = params.get("page");
        String[] sizes = params.get("size");
        String[] sorts = params.get("sort");
        Integer page = null;
        Integer size = null;
        Sort sort = null;
        if (pages != null && pages.length > 0) {
            page = Integer.valueOf(pages[0]);
        }
        if (sizes != null && sizes.length > 0) {
            size = Integer.valueOf(sizes[0]);
        }
        if (sorts != null && sorts.length > 0) {
            for (int i = 0; i < sorts.length; ++i) {
                String sortParam = sorts[i];
                String[] sortArray = sortParam.split(",");
                Sort sigleSort = null;
                if (sortArray.length == 1) {
                    sigleSort = new Sort(Sort.Direction.DESC, new String[]{sorts[0]});
                } else if (sortArray.length == 2) {
                    String direction = sortArray[1];
                    String fieldName = sortArray[0];
                    if ("DESC".equalsIgnoreCase(direction)) {
                        sigleSort = new Sort(Sort.Direction.DESC, new String[]{fieldName});
                    } else if ("ASC".equalsIgnoreCase(direction)) {
                        sigleSort = new Sort(Sort.Direction.ASC, new String[]{fieldName});
                    }
                }
                sort = sort == null ? sigleSort : sort.and(sigleSort);
            }
        }
        if (page != null && size != null) {
            return new PageRequest(page.intValue(), size.intValue(), sort);
        }
        return null;
    }

    public static String extractMoreClause(Map<String, String[]> params) {
        String moreWhereClause = null;
        String[] moreWhereClauses = params.get("more_where_clauses");
        if (moreWhereClauses != null && moreWhereClauses.length > 0) {
            moreWhereClause = " and " + moreWhereClauses[0];
        }
        return moreWhereClause;
    }
}

