package io.g740.client.component;

import io.g740.client.dto.PageResultDTO;
import io.g740.client.dto.SQLGenerResultDTO;
import io.g740.client.entity.DataExportTaskDO;
import io.g740.client.service.DataExportService;
import io.g740.client.service.QueryDataSercive;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @function:
 * @author: DAM
 * @date: 2019/7/19 18:24
 * @description:
 * @version: V1.0
 */
@Component
public class D1ClientComponent {
    @Autowired
    DiscoveryClient discoveryClient;

    @Autowired
    private QueryDataSercive queryDataSercive;

    @Autowired
    private DataExportService dataExportService;

    @Value("${d1-core-service.url:}")
    private String hostAndPortUrl;

    private String formTableSettingForExportUrl = "/d1/export/form-table-setting";

    private String exportUpdateTaskUrl = "/d1/export/update-task";

    private String exportAddTaskUrl = "/d1/export/add-task";

    private String exportTaskStatusUrl = "/d1/export/task-status";

    private String formTableSettingUrl = "/d1/query-suite/general-sql";


    private String getHostAndPortUrl(String serviceId) throws Exception {
        if(StringUtils.isBlank(serviceId)){
            String hostAndPort = this.hostAndPortUrl;
            System.out.println("hostAndPort>>>"+hostAndPort);
            if(StringUtils.isBlank(hostAndPort)){
                throw new Exception("d1-core-service url can not be null");
            }
            return hostAndPort;
        }else{
            List<ServiceInstance> instances = discoveryClient.getInstances(serviceId);
            if (CollectionUtils.isEmpty(instances)) {
                throw new Exception("serviceId is not found!");
            }
            ServiceInstance serviceInstance = instances.get(0);
            String jsonString = JSONObject.toJSONString(serviceInstance);
            JSONObject jsonObject = JSON.parseObject(jsonString);
            JSONObject instanceInfo = jsonObject.getJSONObject("instanceInfo");
            String host = instanceInfo.get("iPAddr") + "";
            System.out.println(host);
            int port = serviceInstance.getPort();
            String url = "http://" + host + ":" + port;
            return url;
        }
    }


    public Long executeExportTask(String dataFacetKey,
                                  DataSource dataSource,
                                  String serviceId,
                                  String fileName,
                                  String fileTempPath,
                                  Map<String, String[]> restructureParameter) throws Exception {
        String hostAndPortUrl = getHostAndPortUrl(serviceId);
        return dataExportService.executeExportTask(dataFacetKey, dataSource,
                fileName, fileTempPath,
                hostAndPortUrl + exportAddTaskUrl,
                hostAndPortUrl + exportUpdateTaskUrl,
                hostAndPortUrl + formTableSettingUrl,
                hostAndPortUrl + formTableSettingForExportUrl,
                restructureParameter);
    }


    public DataExportTaskDO findDataExportTaskById(Long taskId, String serviceId) throws Exception {
        String hostAndPortUrl = getHostAndPortUrl(serviceId);
        String url = hostAndPortUrl + exportTaskStatusUrl;
        return dataExportService.findDataExportTaskById(taskId, url);
    }


    public void exportFileDownload(Long taskId, String serviceId, HttpServletResponse res) throws Exception {
        String hostAndPortUrl = getHostAndPortUrl(serviceId);
        String url = hostAndPortUrl + exportTaskStatusUrl;
        dataExportService.exportFileDownload(taskId, url, res);
    }


    /**
     * 执行查询
     *
     * @param dataFacetKey
     * @param dataSource
     * @param serviceId
     * @param restructureParameter
     * @return
     * @throws Exception
     */
    public PageResultDTO executeQuery(String dataFacetKey,
                                      DataSource dataSource,
                                      boolean usePaging,
                                      String serviceId,
                                      Map<String, String[]> restructureParameter) throws Exception {
        String hostAndPortUrl = getHostAndPortUrl(serviceId);
        String url = hostAndPortUrl + formTableSettingUrl;
        return queryDataSercive.executeQuery(dataFacetKey,
                dataSource,
                usePaging, url,
                restructureParameter);
    }

    public SQLGenerResultDTO generalQuery(String dataFacetKey,
                                          Boolean usePaging,
                                          String serviceId,
                                          Map<String, String[]> requestParams) throws Exception {
        if (requestParams == null) {
            requestParams = new LinkedHashMap<>();
        }
        requestParams.put("data_facet_key", new String[]{dataFacetKey});
        String hostAndPortUrl = getHostAndPortUrl(serviceId);
        String url = hostAndPortUrl + formTableSettingUrl;
        return queryDataSercive.generalQuery(dataFacetKey, usePaging, url, requestParams);
    }


}
