/*
 * Decompiled with CFR 0.152.
 */
package com.fxlabs;

import com.fxlabs.AuthBuilder;
import com.fxlabs.HttpClientFactoryUtil;
import com.fxlabs.dto.base.Response;
import com.fxlabs.dto.run.Run;
import com.fxlabs.dto.run.TaskStatus;
import com.fxlabs.exceptions.FxException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@Mojo(name="job")
public class JobMojo
extends AbstractMojo {
    public static final HashMap<Class, ParameterizedTypeReference> paramTypeRefMap = new HashMap();
    @Parameter(property="job.message", defaultValue="Testing Job")
    private String message;
    @Parameter(property="job.jobId")
    private String jobId;
    @Parameter(property="job.region")
    private String region;
    @Parameter(property="job.categories")
    private String categories;
    @Parameter(property="job.host", defaultValue="https://cloud.fxlabs.io")
    private String host;
    @Parameter(property="job.username")
    private String username;
    @Parameter(property="job.password")
    private String password;
    @Parameter(property="job.noRegressionPass")
    private boolean noRegressionPass = false;
    private static final String HOST_URL = "https://cloud.fxlabs.io";
    private static final String UAT_HOST_URL = "http://13.56.210.25";
    private static final String LOCAL_HOST_URL = "http://localhost:8080";
    private static final String RUN_JOB_API_ENDPOINT = "/api/v1/runs/job/";
    private static final String RUN_STATUS_JOB_API_ENDPOINT = "/api/v1/runs/";

    public void execute() throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)("Username : " + this.username));
            this.getLog().info((CharSequence)("Job Id : " + this.jobId));
            this.getLog().info((CharSequence)("Region : " + this.region));
            String hostUrl = HOST_URL;
            String jobRunUrl = this.host + RUN_JOB_API_ENDPOINT + this.jobId;
            jobRunUrl = this.appendQuerryParams(jobRunUrl);
            String runStatusUrl = this.host + RUN_STATUS_JOB_API_ENDPOINT;
            RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)HttpClientFactoryUtil.httpComponentsClientHttpRequestFactory());
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.setContentType(MediaType.APPLICATION_JSON);
            httpHeaders.set("Accept", "application/json");
            httpHeaders.set("Authorization", AuthBuilder.createBasicAuth(this.username, this.password));
            HttpEntity request = new HttpEntity((Object)"", (MultiValueMap)httpHeaders);
            ResponseEntity response = null;
            int statusCode = -1;
            Object responseBody = null;
            Object headers = null;
            this.getLog().info((CharSequence)("calling " + jobRunUrl));
            response = restTemplate.exchange(jobRunUrl, HttpMethod.POST, request, paramTypeRefMap.get(Run.class), new Object[0]);
            Response response1 = (Response)response.getBody();
            String runId = ((Run)response1.getData()).getId();
            if (StringUtils.isEmpty((Object)runId)) {
                throw new MojoExecutionException("Invalid runid." + runId);
            }
            this.getLog().info((CharSequence)("Run Id : " + runId));
            TaskStatus status1 = ((Run)response1.getData()).getTask().getStatus();
            if (status1 == null || StringUtils.isEmpty((Object)status1.toString())) {
                throw new MojoExecutionException("Invalid status " + status1.toString());
            }
            Run run = null;
            do {
                Response response2;
                if ((run = (Run)(response2 = (Response)(response = restTemplate.exchange(runStatusUrl + runId, HttpMethod.GET, request, paramTypeRefMap.get(Run.class), new Object[0])).getBody()).getData()) == null || run.getTask() == null) {
                    throw new MojoExecutionException("Failed to get status.");
                }
                status1 = run.getTask().getStatus();
                String[] dataArray = run.getCiCdStatus().split(":");
                if (run.getTask() == null || StringUtils.isEmpty((Object)((Object)status1))) {
                    throw new MojoExecutionException("Invalid status." + status1.toString());
                }
                double success = 0.0;
                try {
                    long l = run.getTask().getTotalTests() - run.getTask().getFailedTests();
                    success = l * 100L / run.getTask().getTotalTests();
                }
                catch (Exception e) {
                    e.getLocalizedMessage();
                }
                this.getLog().info((CharSequence)("Status: " + (Object)((Object)status1) + ".....\r"));
                if (TaskStatus.COMPLETED.equals((Object)run.getTask().getStatus())) {
                    this.printStatus(dataArray);
                    if (!(this.noRegressionPass || run.getTask().getIssuesLogged() <= 0L && run.getTask().getTotalOpenIssues() <= 0L)) {
                        throw new MojoExecutionException(String.format("New : %s Open : %s Closed : %s", run.getTask().getIssuesLogged(), run.getTask().getTotalOpenIssues(), run.getTask().getIssuesClosed()));
                    }
                    if (this.noRegressionPass && run.getTask().getIssuesLogged() > 0L) {
                        throw new MojoExecutionException(String.format("New : %s Open : %s Closed : %s", run.getTask().getIssuesLogged(), run.getTask().getTotalOpenIssues(), run.getTask().getIssuesClosed()));
                    }
                }
                if (TaskStatus.FAIL.equals((Object)run.getTask().getStatus())) {
                    this.getLog().info((CharSequence)("Reason for Failure : " + dataArray[1]));
                    throw new MojoExecutionException(run.getTask().getDescription());
                }
                if (TaskStatus.TIMEOUT.equals((Object)run.getTask().getStatus())) {
                    this.printStatus(dataArray);
                    throw new MojoExecutionException("Job timeout.....");
                }
                try {
                    TimeUnit.SECONDS.sleep(5L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } while (TaskStatus.WAITING.equals((Object)status1) || TaskStatus.PROCESSING.equals((Object)status1));
            if (run != null && run.getTask() != null) {
                this.getLog().info((CharSequence)String.format("New : %s Open : %s Closed : %s", run.getTask().getIssuesLogged(), run.getTask().getTotalOpenIssues(), run.getTask().getIssuesClosed()));
            }
        }
        catch (HttpStatusCodeException statusCodeException) {
            this.getLog().info((CharSequence)(statusCodeException.toString() + statusCodeException.getResponseBodyAsString() + statusCodeException.getResponseHeaders()));
            throw new MojoExecutionException(statusCodeException.toString() + statusCodeException.getResponseBodyAsString() + statusCodeException.getResponseHeaders());
        }
        catch (FxException fx) {
            throw new MojoExecutionException(fx.toString());
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)e.getLocalizedMessage());
            throw new MojoExecutionException(e.getLocalizedMessage());
        }
    }

    private String appendQuerryParams(String jobRunUrl) {
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.region)) {
            jobRunUrl = jobRunUrl + "?region=" + this.region;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.categories) && jobRunUrl.contains("?")) {
            jobRunUrl = jobRunUrl + "&categories=" + this.categories;
        } else if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.categories) && !jobRunUrl.contains("?")) {
            jobRunUrl = jobRunUrl + "?categories=" + this.categories;
        }
        return jobRunUrl;
    }

    private void printStatus(String[] dataArray) {
        this.getLog().info((CharSequence)"----------------------------------------");
        this.getLog().info((CharSequence)("Run detail's link " + this.host + dataArray[7] + "/" + dataArray[6]));
        this.getLog().info((CharSequence)"----------------------------------------");
        this.getLog().info((CharSequence)("Success : " + dataArray[1] + " %  -- Total Tests : " + dataArray[2] + " -- Failed Tests : " + dataArray[3]));
        this.getLog().info((CharSequence)"----------------------------------------");
    }

    static {
        paramTypeRefMap.put(Run.class, (ParameterizedTypeReference)new ParameterizedTypeReference<Response<Run>>(){});
    }
}

