/*
 * Decompiled with CFR 0.152.
 */
package com.fxlabs.dto.run;

import com.fxlabs.dto.base.BaseDto;
import com.fxlabs.dto.project.Job;
import com.fxlabs.dto.run.RunTask;
import java.util.HashMap;
import java.util.Map;

public class Run
extends BaseDto<String> {
    private Job job;
    private Long runId;
    private RunTask task;
    private Map<String, String> attributes = new HashMap<String, String>();
    private String regions;
    private Map<String, Long> stats = new HashMap<String, Long>();
    private Integer validations;
    private String ciCdStatus;

    public String getCiCdStatus() {
        StringBuilder sb = new StringBuilder();
        double success = 0.0;
        try {
            long l = this.task.getTotalTests() - this.task.getFailedTests();
            success = l * 100L / this.task.getTotalTests();
        }
        catch (Exception e) {
            e.getLocalizedMessage();
        }
        if (this.task.getStatus().toString() == "FAIL") {
            sb.append(this.task.getStatus().toString()).append(":").append(this.task.getDescription());
        }
        sb.append(this.task.getStatus().toString()).append(":").append(success).append(":").append(this.task.getTotalTests()).append(":").append(this.task.getFailedTests()).append(":").append(this.task.getTimeTaken()).append(":").append(this.task.getDescription()).append(":").append(this.getRunId()).append(":").append("/#/app/projects/" + this.job.getProject().getId() + "/jobs/" + this.job.getId() + "/runs/" + this.getId()).append(":").append("Bugs Logged = " + this.task.getIssuesLogged() + " Bugs Reopened = " + this.task.getIssuesReopen() + " Bugs Closed = " + this.task.getIssuesClosed() + " Total Bugs = " + this.task.getTotalOpenIssues());
        return sb.toString();
    }

    public Job getJob() {
        return this.job;
    }

    public Long getRunId() {
        return this.runId;
    }

    public RunTask getTask() {
        return this.task;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getRegions() {
        return this.regions;
    }

    public Map<String, Long> getStats() {
        return this.stats;
    }

    public Integer getValidations() {
        return this.validations;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public void setRunId(Long runId) {
        this.runId = runId;
    }

    public void setTask(RunTask task) {
        this.task = task;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public void setRegions(String regions) {
        this.regions = regions;
    }

    public void setStats(Map<String, Long> stats) {
        this.stats = stats;
    }

    public void setValidations(Integer validations) {
        this.validations = validations;
    }

    public void setCiCdStatus(String ciCdStatus) {
        this.ciCdStatus = ciCdStatus;
    }

    @Override
    public String toString() {
        return "Run(job=" + this.getJob() + ", runId=" + this.getRunId() + ", task=" + this.getTask() + ", attributes=" + this.getAttributes() + ", regions=" + this.getRegions() + ", stats=" + this.getStats() + ", validations=" + this.getValidations() + ", ciCdStatus=" + this.getCiCdStatus() + ")";
    }

    public Run(Job job, Long runId, RunTask task, Map<String, String> attributes, String regions, Map<String, Long> stats, Integer validations, String ciCdStatus) {
        this.job = job;
        this.runId = runId;
        this.task = task;
        this.attributes = attributes;
        this.regions = regions;
        this.stats = stats;
        this.validations = validations;
        this.ciCdStatus = ciCdStatus;
    }

    public Run() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Run)) {
            return false;
        }
        Run other = (Run)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Job this$job = this.getJob();
        Job other$job = other.getJob();
        if (this$job == null ? other$job != null : !((Object)this$job).equals(other$job)) {
            return false;
        }
        Long this$runId = this.getRunId();
        Long other$runId = other.getRunId();
        if (this$runId == null ? other$runId != null : !((Object)this$runId).equals(other$runId)) {
            return false;
        }
        RunTask this$task = this.getTask();
        RunTask other$task = other.getTask();
        if (this$task == null ? other$task != null : !((Object)this$task).equals(other$task)) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        String this$regions = this.getRegions();
        String other$regions = other.getRegions();
        if (this$regions == null ? other$regions != null : !this$regions.equals(other$regions)) {
            return false;
        }
        Map<String, Long> this$stats = this.getStats();
        Map<String, Long> other$stats = other.getStats();
        if (this$stats == null ? other$stats != null : !((Object)this$stats).equals(other$stats)) {
            return false;
        }
        Integer this$validations = this.getValidations();
        Integer other$validations = other.getValidations();
        if (this$validations == null ? other$validations != null : !((Object)this$validations).equals(other$validations)) {
            return false;
        }
        String this$ciCdStatus = this.getCiCdStatus();
        String other$ciCdStatus = other.getCiCdStatus();
        return !(this$ciCdStatus == null ? other$ciCdStatus != null : !this$ciCdStatus.equals(other$ciCdStatus));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Run;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Job $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : ((Object)$job).hashCode());
        Long $runId = this.getRunId();
        result = result * 59 + ($runId == null ? 43 : ((Object)$runId).hashCode());
        RunTask $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : ((Object)$task).hashCode());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        String $regions = this.getRegions();
        result = result * 59 + ($regions == null ? 43 : $regions.hashCode());
        Map<String, Long> $stats = this.getStats();
        result = result * 59 + ($stats == null ? 43 : ((Object)$stats).hashCode());
        Integer $validations = this.getValidations();
        result = result * 59 + ($validations == null ? 43 : ((Object)$validations).hashCode());
        String $ciCdStatus = this.getCiCdStatus();
        result = result * 59 + ($ciCdStatus == null ? 43 : $ciCdStatus.hashCode());
        return result;
    }
}

