/*
 * Decompiled with CFR 0.152.
 */
package com.fxlabs;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;

public class HttpClientFactoryUtil {
    private static HttpComponentsClientHttpRequestFactory FACTORY = null;

    public static final HttpComponentsClientHttpRequestFactory getInstance() {
        if (FACTORY != null) {
            return FACTORY;
        }
        CloseableHttpClient httpClient = HttpClients.custom().setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).build();
        FACTORY = new HttpComponentsClientHttpRequestFactory();
        FACTORY.setHttpClient((HttpClient)httpClient);
        int timeout = 15000;
        FACTORY.setConnectTimeout(timeout);
        FACTORY.setConnectionRequestTimeout(timeout);
        FACTORY.setReadTimeout(timeout);
        return FACTORY;
    }

    public static HttpComponentsClientHttpRequestFactory httpComponentsClientHttpRequestFactory() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        TrustStrategy acceptingTrustStrategy = (chain, authType) -> true;
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, acceptingTrustStrategy).build();
        SSLConnectionSocketFactory csf = new SSLConnectionSocketFactory(sslContext);
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)csf).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setHttpClient((HttpClient)httpClient);
        return requestFactory;
    }
}

