/*
 * Decompiled with CFR 0.152.
 */
package com.fxlabs;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fxlabs.AuthBuilder;
import com.fxlabs.HttpClientFactoryUtil;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@Mojo(name="job")
public class JobMojo
extends AbstractMojo {
    @Parameter(property="job.message", defaultValue="Testing Job")
    private String message;
    @Parameter(property="job.jobId")
    private String jobId;
    @Parameter(property="job.region")
    private String region;
    @Parameter(property="job.host", defaultValue="https://cloud.fxlabs.io")
    private String host;
    @Parameter(property="job.username")
    private String username;
    @Parameter(property="job.password")
    private String password;
    private static final String HOST_URL = "https://cloud.fxlabs.io";
    private static final String UAT_HOST_URL = "http://13.56.210.25";
    private static final String LOCAL_HOST_URL = "http://localhost:8080";
    private static final String RUN_JOB_API_ENDPOINT = "/api/v1/runs/job/";
    private static final String RUN_STATUS_JOB_API_ENDPOINT = "/api/v1/runs/";

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Username : " + this.username));
        this.getLog().info((CharSequence)("Job Id : " + this.jobId));
        this.getLog().info((CharSequence)("Region : " + this.region));
        String hostUrl = HOST_URL;
        String jobRunUrl = this.host + RUN_JOB_API_ENDPOINT + this.jobId + "?region=" + this.region;
        String runStatusUrl = this.host + RUN_STATUS_JOB_API_ENDPOINT;
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)HttpClientFactoryUtil.getInstance());
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        httpHeaders.set("Accept", "application/json");
        httpHeaders.set("Authorization", AuthBuilder.createBasicAuth(this.username, this.password));
        HttpEntity request = new HttpEntity((Object)"", (MultiValueMap)httpHeaders);
        ResponseEntity response = null;
        int statusCode = -1;
        Object responseBody = null;
        Object headers = null;
        try {
            this.getLog().info((CharSequence)("calling " + jobRunUrl));
            response = restTemplate.exchange(jobRunUrl, HttpMethod.POST, request, String.class, new Object[0]);
            String runId = this.getByKeyId((String)response.getBody(), "id", "");
            if (StringUtils.isEmpty((Object)runId)) {
                throw new MojoExecutionException("Invalid runid." + runId);
            }
            this.getLog().info((CharSequence)("Run Id : " + runId));
            String status = this.getByKeyId((String)response.getBody(), "task", "status");
            if (StringUtils.isEmpty((Object)status)) {
                throw new MojoExecutionException("Invalid status " + status);
            }
            this.getLog().info((CharSequence)("status : " + status));
            do {
                try {
                    TimeUnit.SECONDS.sleep(5L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.getLog().info((CharSequence)"Checking status ........");
                response = restTemplate.exchange(runStatusUrl + runId, HttpMethod.GET, request, String.class, new Object[0]);
                String ciCdStatus = this.getByKeyId((String)response.getBody(), "ciCdStatus", "");
                if (StringUtils.isEmpty((Object)ciCdStatus)) {
                    throw new MojoExecutionException("Failed to get status.");
                }
                String[] dataArray = ciCdStatus.split(":");
                status = dataArray[0];
                if (StringUtils.isEmpty((Object)status)) {
                    throw new MojoExecutionException("Invalid status." + status);
                }
                this.getLog().info((CharSequence)("Run Status: " + status + "....."));
                if ("COMPLETED".equalsIgnoreCase(status)) {
                    this.printStatus(dataArray);
                }
                if ("FAIL".equalsIgnoreCase(status)) {
                    this.getLog().info((CharSequence)("Reason for Failure : " + dataArray[1]));
                }
                if (!"TIMEOUT".equalsIgnoreCase(status)) continue;
                this.printStatus(dataArray);
                throw new MojoExecutionException("Job timeout.....");
            } while ("WAITING".equalsIgnoreCase(status) || "PROCESSING".equalsIgnoreCase(status));
        }
        catch (HttpStatusCodeException statusCodeException) {
            this.getLog().info((CharSequence)jobRunUrl);
            this.getLog().info((CharSequence)(statusCodeException.toString() + statusCodeException.getResponseBodyAsString() + statusCodeException.getResponseHeaders()));
            throw new MojoExecutionException(statusCodeException.toString() + statusCodeException.getResponseBodyAsString() + statusCodeException.getResponseHeaders());
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)e.getLocalizedMessage());
            throw new MojoExecutionException(e.getLocalizedMessage());
        }
    }

    private void printStatus(String[] dataArray) {
        this.getLog().info((CharSequence)"----------------------------------------");
        this.getLog().info((CharSequence)("Run detail's link " + this.host + dataArray[6]));
        this.getLog().info((CharSequence)"----------------------------------------");
        this.getLog().info((CharSequence)dataArray[7]);
        this.getLog().info((CharSequence)"----------------------------------------");
        this.getLog().info((CharSequence)("Run No : " + dataArray[5]));
        this.getLog().info((CharSequence)"----------------------------------------");
        this.getLog().info((CharSequence)("Success : " + dataArray[1] + " %  -- Total Tests : " + dataArray[2] + " -- Failed Tests : " + dataArray[3]));
        this.getLog().info((CharSequence)"----------------------------------------");
    }

    public String getByKeyId(String value, String key1, String key2) {
        if (StringUtils.isEmpty((Object)value)) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode rootNode = mapper.readTree(value);
            JsonNode nameNode = null;
            if (StringUtils.isEmpty((Object)key2) && !StringUtils.isEmpty((Object)key1)) {
                nameNode = rootNode.path("data").path(key1);
            } else if (!StringUtils.isEmpty((Object)key2) && !StringUtils.isEmpty((Object)key1)) {
                nameNode = rootNode.path("data").path(key1).path(key2);
            }
            return nameNode.textValue();
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)e.getLocalizedMessage());
            return null;
        }
    }
}

