/*
 * Decompiled with CFR 0.152.
 */
package io.fsq.spindle.common.thrift.json;

import io.fsq.spindle.common.thrift.base.EnhancedTField;
import io.fsq.spindle.common.thrift.base.NonStringMapKeyException;
import io.fsq.spindle.common.thrift.base.SerializeDatesAsSeconds;
import io.fsq.spindle.common.thrift.base.TTransportInputStream;
import io.fsq.spindle.common.thrift.base.TTransportOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Stack;
import javax.xml.bind.DatatypeConverter;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.transport.TTransport;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.PrettyPrinter;
import org.codehaus.jackson.SerializableString;
import org.codehaus.jackson.io.CharacterEscapes;
import org.codehaus.jackson.io.SerializedString;
import org.codehaus.jackson.util.DefaultPrettyPrinter;
import org.codehaus.jackson.util.TokenBuffer;

public class TReadableJSONProtocol
extends TProtocol
implements SerializeDatesAsSeconds {
    private static final TMessage ANONYMOUS_MESSAGE = new TMessage();
    private static final TStruct ANONYMOUS_STRUCT = new TStruct();
    private static final short UNKNOWN_FIELD_ID = -1;
    private static final byte UNKNOWN_TTYPE = 1;
    private static final TField NO_MORE_FIELDS = new TField("", 0, 0);
    private final JsonFactory jsonFactory;
    private JsonGenerator jg = null;
    private final PrettyPrinter prettyPrinter;
    private boolean coerceMapKeys = false;
    private boolean bareObjectIds = false;
    private boolean numbersAsStrings = false;
    private JsonParser jp = null;
    private final Stack<ReadContext> readContextStack = new Stack();
    private String enhancedType = null;

    public TReadableJSONProtocol(TTransport tTransport, PrettyPrinter prettyPrinter) {
        this(tTransport, prettyPrinter, null);
    }

    public TReadableJSONProtocol(TTransport tTransport, PrettyPrinter prettyPrinter, JsonParser jsonParser) {
        this(tTransport, prettyPrinter, jsonParser, false, false, false);
    }

    public TReadableJSONProtocol(TTransport tTransport, PrettyPrinter prettyPrinter, JsonParser jsonParser, boolean bl) {
        this(tTransport, prettyPrinter, jsonParser, bl, false, false);
    }

    public TReadableJSONProtocol(TTransport tTransport, PrettyPrinter prettyPrinter, JsonParser jsonParser, boolean bl, boolean bl2) {
        this(tTransport, prettyPrinter, jsonParser, bl, bl2, false);
    }

    public TReadableJSONProtocol(TTransport tTransport, PrettyPrinter prettyPrinter, JsonParser jsonParser, boolean bl, boolean bl2, boolean bl3) {
        super(tTransport);
        this.prettyPrinter = prettyPrinter;
        this.jsonFactory = new JsonFactory();
        this.jsonFactory.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        this.jsonFactory.setCharacterEscapes((CharacterEscapes)new JsonCharacterEscapes());
        if (jsonParser != null) {
            this.jp = jsonParser;
        }
        this.coerceMapKeys = bl;
        this.bareObjectIds = bl2;
        this.numbersAsStrings = bl3;
    }

    public static byte getElemTypeFromToken(JsonToken jsonToken) throws TException {
        byte by = 1;
        switch (jsonToken) {
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                by = 2;
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                by = 4;
                break;
            }
            case VALUE_NUMBER_INT: {
                by = 10;
                break;
            }
            case VALUE_STRING: {
                by = 11;
                break;
            }
            case START_ARRAY: {
                by = 15;
                break;
            }
            case START_OBJECT: {
                by = 12;
                break;
            }
            case VALUE_NULL: {
                by = 11;
            }
        }
        if (by == 1) {
            throw new TException("Invalid token value type: " + jsonToken);
        }
        return by;
    }

    private static byte[] toByteArray(ArrayList<Byte> arrayList) {
        int n = arrayList.size();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = arrayList.get(i);
        }
        return byArray;
    }

    private void wrapIOException(IOException iOException) throws TException {
        throw new TException("IOException: " + iOException.getMessage());
    }

    private void wrapIOException(IOException iOException, Object object) throws TException {
        if (iOException.getMessage().endsWith("expecting field name")) {
            throw new NonStringMapKeyException(object);
        }
        this.wrapIOException(iOException);
    }

    public void reset() {
        this.enhancedType = null;
        this.jg = null;
        this.jp = null;
        this.readContextStack.clear();
    }

    public void writeMessageBegin(TMessage tMessage) throws TException {
    }

    public void writeMessageEnd() throws TException {
    }

    public void writeStructBegin(TStruct tStruct) throws TException {
        if (this.jg == null) {
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new TTransportOutputStream(this.getTransport()));
                this.jg = this.jsonFactory.createJsonGenerator((Writer)outputStreamWriter);
                if (this.prettyPrinter != null) {
                    this.jg.setPrettyPrinter(this.prettyPrinter);
                }
            }
            catch (IOException iOException) {
                this.wrapIOException(iOException);
            }
        }
        try {
            this.jg.writeStartObject();
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    public void writeStructEnd() throws TException {
        try {
            this.jg.writeEndObject();
            this.jg.flush();
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    public void writeFieldBegin(TField tField) throws TException {
        try {
            this.jg.writeFieldName(tField.name);
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
        if (tField instanceof EnhancedTField) {
            this.enhancedType = (String)((EnhancedTField)tField).enhancedTypes.get("bson");
        }
    }

    public void writeFieldEnd() throws TException {
    }

    public void writeFieldStop() throws TException {
    }

    public void writeMapBegin(TMap tMap) throws TException {
        try {
            this.jg.writeStartObject();
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    public void writeMapEnd() throws TException {
        try {
            this.jg.writeEndObject();
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    public void writeListBegin(TList tList) throws TException {
        try {
            this.jg.writeStartArray();
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    public void writeListEnd() throws TException {
        try {
            this.jg.writeEndArray();
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    public void writeSetBegin(TSet tSet) throws TException {
        try {
            this.jg.writeStartArray();
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    public void writeSetEnd() throws TException {
        try {
            this.jg.writeEndArray();
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeBool(boolean bl) throws TException {
        try {
            if (this.isMapKey()) {
                if (!this.coerceMapKeys) throw new NonStringMapKeyException((Object)bl);
                this.jg.writeFieldName(Boolean.toString(bl));
                return;
            } else {
                this.jg.writeBoolean(bl);
            }
            return;
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeByte(byte by) throws TException {
        try {
            if (this.isMapKey()) {
                if (!this.coerceMapKeys) throw new NonStringMapKeyException((Object)by);
                this.jg.writeFieldName(Byte.toString(by));
                return;
            } else {
                this.jg.writeNumber((int)by);
            }
            return;
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException, by);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeI16(short s) throws TException {
        try {
            if (this.isMapKey()) {
                if (!this.coerceMapKeys) throw new NonStringMapKeyException((Object)s);
                this.jg.writeFieldName(Short.toString(s));
                return;
            } else if (this.numbersAsStrings) {
                this.jg.writeString(Integer.toString(s));
                return;
            } else {
                this.jg.writeNumber((int)s);
            }
            return;
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException, s);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeI32(int n) throws TException {
        try {
            if (this.isMapKey()) {
                if (!this.coerceMapKeys) throw new NonStringMapKeyException((Object)n);
                this.jg.writeFieldName(Integer.toString(n));
                return;
            } else if (this.numbersAsStrings) {
                this.jg.writeString(Integer.toString(n));
                return;
            } else {
                this.jg.writeNumber(n);
            }
            return;
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException, n);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeI64(long l) throws TException {
        try {
            if (this.isMapKey()) {
                if (!this.coerceMapKeys) throw new NonStringMapKeyException((Object)l);
                this.jg.writeFieldName(Long.toString(l));
                return;
            } else if (this.numbersAsStrings) {
                this.jg.writeString(Long.toString(l));
                return;
            } else {
                this.jg.writeNumber(l);
            }
            return;
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException, l);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeDouble(double d) throws TException {
        try {
            if (this.isMapKey()) {
                if (!this.coerceMapKeys) throw new NonStringMapKeyException((Object)d);
                this.jg.writeFieldName(Double.toString(d));
                return;
            } else if (this.numbersAsStrings) {
                this.jg.writeString(Double.toString(d));
                return;
            } else {
                this.jg.writeNumber(d);
            }
            return;
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException, d);
        }
    }

    public void writeString(String string) throws TException {
        try {
            if (this.isMapKey()) {
                this.jg.writeFieldName(string);
            } else {
                this.jg.writeString(string);
            }
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeBinary(ByteBuffer byteBuffer) throws TException {
        try {
            byte[] byArray = TBaseHelper.byteBufferToByteArray((ByteBuffer)byteBuffer);
            if (this.isMapKey()) {
                if (!this.coerceMapKeys) throw new NonStringMapKeyException((Object)byArray);
                this.jg.writeFieldName(this.toObjectIdString(byArray));
                return;
            } else if ("ObjectId".equals(this.enhancedType)) {
                this.jg.writeString(this.toObjectIdString(byArray));
                return;
            } else {
                this.jg.writeString(this.toBase64String(byArray));
            }
            return;
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException, byteBuffer);
        }
    }

    private boolean isMapKey() {
        return this.jg.getOutputContext().inObject() && this.jg.getOutputContext().getCurrentName() == null;
    }

    private String toObjectIdString(byte[] byArray) {
        String string = DatatypeConverter.printHexBinary((byte[])byArray).toLowerCase();
        if (this.bareObjectIds) {
            return string;
        }
        return "ObjectId(\"" + string + "\")";
    }

    private String toBase64String(byte[] byArray) {
        String string = DatatypeConverter.printBase64Binary((byte[])byArray);
        if (this.bareObjectIds) {
            return "Base64(\"" + string + "\")";
        }
        return string;
    }

    private byte[] decodeBinaryString(String string) {
        try {
            if (this.bareObjectIds) {
                if (string.startsWith("Base64(\"") && string.endsWith("\")")) {
                    String string2 = string.substring(8, string.length() - 2);
                    return DatatypeConverter.parseBase64Binary((String)string2);
                }
                return DatatypeConverter.parseHexBinary((String)string);
            }
            if (string.startsWith("ObjectId(\"") && string.endsWith("\")")) {
                String string3 = string.substring(10, string.length() - 2);
                return DatatypeConverter.parseHexBinary((String)string3);
            }
            return DatatypeConverter.parseBase64Binary((String)string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public TMessage readMessageBegin() throws TException {
        return ANONYMOUS_MESSAGE;
    }

    public void readMessageEnd() throws TException {
    }

    public TStruct readStructBegin() throws TException {
        if (this.jp == null) {
            try {
                this.jp = this.jsonFactory.createJsonParser((InputStream)new TTransportInputStream(this.getTransport()));
            }
            catch (IOException iOException) {
                this.wrapIOException(iOException);
            }
        }
        if (this.readContextStack.empty()) {
            this.readContextStack.push(new ObjectReadContext(this.jp));
        } else {
            this.readContextStack.push(new ObjectReadContext(this.currentReadContext().parser()));
        }
        return ANONYMOUS_STRUCT;
    }

    public void readStructEnd() throws TException {
        this.popCurrentReadContext();
    }

    public TField readFieldBegin() throws TException {
        String string = (String)this.currentReadContext().getNextItem();
        if (string == null) {
            return NO_MORE_FIELDS;
        }
        byte by = this.currentReadContext().valueTType();
        return new TField(string, by, -1);
    }

    public void readFieldEnd() throws TException {
    }

    private boolean areAllElementsEqual(byte[] byArray) {
        for (int i = 1; i < byArray.length; ++i) {
            if (byArray[i - 1] == byArray[i]) continue;
            return false;
        }
        return true;
    }

    public TMap readMapBegin() throws TException {
        MapReadContext mapReadContext = new MapReadContext(this.currentReadContext().parser());
        this.readContextStack.push(mapReadContext);
        byte[] byArray = mapReadContext.valueTTypes();
        byte by = byArray.length > 0 && this.areAllElementsEqual(byArray) ? byArray[0] : (byte)1;
        return new TMap(11, by, mapReadContext.mapSize());
    }

    public void readMapEnd() throws TException {
        this.popCurrentReadContext();
    }

    public TList readListBegin() throws TException {
        ArrayReadContext arrayReadContext = new ArrayReadContext(this.currentReadContext().parser());
        this.readContextStack.push(arrayReadContext);
        byte[] byArray = arrayReadContext.tTypes();
        byte by = byArray.length > 0 && this.areAllElementsEqual(byArray) ? byArray[0] : (byte)1;
        return new TList(by, arrayReadContext.listSize());
    }

    public byte[] readListBeginEnhanced() throws TException {
        ArrayReadContext arrayReadContext = new ArrayReadContext(this.currentReadContext().parser());
        this.readContextStack.push(arrayReadContext);
        return arrayReadContext.tTypes();
    }

    public void readListEnd() throws TException {
        this.popCurrentReadContext();
    }

    public TSet readSetBegin() throws TException {
        ArrayReadContext arrayReadContext = new ArrayReadContext(this.currentReadContext().parser());
        this.readContextStack.push(arrayReadContext);
        byte[] byArray = arrayReadContext.tTypes();
        byte by = byArray.length > 0 && this.areAllElementsEqual(byArray) ? byArray[0] : (byte)1;
        return new TSet(by, arrayReadContext.listSize());
    }

    public void readSetEnd() throws TException {
        this.popCurrentReadContext();
    }

    public boolean readBool() throws TException {
        JsonToken jsonToken = (JsonToken)this.currentReadContext().getNextItem();
        try {
            if (jsonToken != JsonToken.VALUE_TRUE && jsonToken != JsonToken.VALUE_FALSE) {
                throw new TException("Expecting boolean field value");
            }
            return this.currentReadContext().parser().getValueAsBoolean();
        }
        catch (IOException iOException) {
            throw new TException((Throwable)iOException);
        }
    }

    public byte readByte() throws TException {
        JsonToken jsonToken = (JsonToken)this.currentReadContext().getNextItem();
        try {
            if (jsonToken != JsonToken.VALUE_NUMBER_INT) {
                throw new TException("Expecting int field value");
            }
            return new Integer(this.currentReadContext().parser().getValueAsInt()).byteValue();
        }
        catch (IOException iOException) {
            throw new TException((Throwable)iOException);
        }
    }

    public short readI16() throws TException {
        JsonToken jsonToken = (JsonToken)this.currentReadContext().getNextItem();
        try {
            if (jsonToken != JsonToken.VALUE_NUMBER_INT) {
                throw new TException("Expecting int field value");
            }
            return new Integer(this.currentReadContext().parser().getValueAsInt()).shortValue();
        }
        catch (IOException iOException) {
            throw new TException((Throwable)iOException);
        }
    }

    public int readI32() throws TException {
        JsonToken jsonToken = (JsonToken)this.currentReadContext().getNextItem();
        try {
            if (jsonToken != JsonToken.VALUE_NUMBER_INT) {
                throw new TException("Expecting int field value, got: " + jsonToken);
            }
            return this.currentReadContext().parser().getValueAsInt();
        }
        catch (IOException iOException) {
            throw new TException((Throwable)iOException);
        }
    }

    public long readI64() throws TException {
        JsonToken jsonToken = (JsonToken)this.currentReadContext().getNextItem();
        try {
            if (jsonToken != JsonToken.VALUE_NUMBER_INT) {
                throw new TException("Expecting int field value");
            }
            return this.currentReadContext().parser().getValueAsLong();
        }
        catch (IOException iOException) {
            throw new TException((Throwable)iOException);
        }
    }

    public double readDouble() throws TException {
        JsonToken jsonToken = (JsonToken)this.currentReadContext().getNextItem();
        try {
            if (jsonToken == JsonToken.VALUE_STRING) {
                String string = this.currentReadContext().parser().getText();
                try {
                    return new Double(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new TException((Throwable)numberFormatException);
                }
            }
            if (jsonToken != JsonToken.VALUE_NUMBER_FLOAT && jsonToken != JsonToken.VALUE_NUMBER_INT) {
                throw new TException("Expecting float field value");
            }
            return this.currentReadContext().parser().getValueAsDouble();
        }
        catch (IOException iOException) {
            throw new TException((Throwable)iOException);
        }
    }

    public String readString() throws TException {
        JsonToken jsonToken = (JsonToken)this.currentReadContext().getNextItem();
        if (jsonToken != JsonToken.FIELD_NAME || this.currentReadContext().valueTType() != 13) {
            if (jsonToken == JsonToken.VALUE_NULL) {
                return null;
            }
            if (jsonToken != JsonToken.VALUE_STRING) {
                throw new TException("Expecting string field value for:" + jsonToken);
            }
        }
        try {
            return this.currentReadContext().parser().getText();
        }
        catch (IOException iOException) {
            throw new TException((Throwable)iOException);
        }
    }

    public ByteBuffer readBinary() throws TException {
        JsonToken jsonToken = (JsonToken)this.currentReadContext().getNextItem();
        if (jsonToken != JsonToken.VALUE_STRING) {
            return null;
        }
        try {
            String string = this.currentReadContext().parser().getText();
            byte[] byArray = this.decodeBinaryString(string);
            if (byArray == null) {
                return null;
            }
            return ByteBuffer.wrap(byArray);
        }
        catch (IOException iOException) {
            throw new TException((Throwable)iOException);
        }
    }

    private ReadContext currentReadContext() throws TException {
        try {
            return this.readContextStack.peek();
        }
        catch (EmptyStackException emptyStackException) {
            throw new TException("Can't read outside an object or array context");
        }
    }

    private ReadContext popCurrentReadContext() throws TException {
        try {
            ReadContext readContext = this.readContextStack.pop();
            readContext.contextPopped();
            if (this.readContextStack.size() > 0) {
                this.currentReadContext().contextRestored();
            }
            return readContext;
        }
        catch (EmptyStackException emptyStackException) {
            throw new TException("Can't pop off an empty read context stack");
        }
    }

    private static final class JsonCharacterEscapes
    extends CharacterEscapes {
        private final int[] escapes = CharacterEscapes.standardAsciiEscapesForJSON();

        public JsonCharacterEscapes() {
            this.escapes[47] = -2;
        }

        public int[] getEscapeCodesForAscii() {
            return this.escapes;
        }

        public SerializableString getEscapeSequence(int n) {
            if (n == 47) {
                return new SerializedString("\\/");
            }
            if (Character.isISOControl(n) || n >= 8192 && n < 8448) {
                return new SerializedString("\\u" + String.format("%04x", n));
            }
            return null;
        }
    }

    private static class ArrayReadContext
    extends ReadContext {
        private final JsonParser jsonParser;
        private final JsonParser bufferParser;
        private final byte[] elemTypes;

        ArrayReadContext(JsonParser jsonParser) throws TException {
            ArrayList<Byte> arrayList = new ArrayList<Byte>();
            this.jsonParser = jsonParser;
            JsonToken jsonToken = this.jsonParser.getCurrentToken();
            if (jsonToken != JsonToken.START_ARRAY) {
                try {
                    jsonToken = this.jsonParser.nextToken();
                }
                catch (IOException iOException) {
                    throw new TException((Throwable)iOException);
                }
                if (jsonToken != JsonToken.START_ARRAY) {
                    throw new TException("Array read expecting start array, got: " + jsonToken);
                }
            }
            try {
                TokenBuffer tokenBuffer = new TokenBuffer(null);
                tokenBuffer.copyCurrentEvent(this.jsonParser);
                int n = 0;
                JsonToken jsonToken2 = null;
                boolean bl = false;
                while (!bl) {
                    jsonToken2 = this.jsonParser.nextToken();
                    tokenBuffer.copyCurrentEvent(this.jsonParser);
                    if (n == 0 && jsonToken2 != JsonToken.END_ARRAY && jsonToken2 != JsonToken.END_OBJECT) {
                        arrayList.add(TReadableJSONProtocol.getElemTypeFromToken(jsonToken2));
                    }
                    switch (jsonToken2) {
                        case START_OBJECT: {
                            ++n;
                            break;
                        }
                        case START_ARRAY: {
                            ++n;
                            break;
                        }
                        case END_OBJECT: {
                            --n;
                            break;
                        }
                        case END_ARRAY: {
                            if (--n != -1) break;
                            bl = true;
                        }
                    }
                }
                this.elemTypes = TReadableJSONProtocol.toByteArray(arrayList);
                this.bufferParser = tokenBuffer.asParser();
                this.bufferParser.nextToken();
                if (this.elemTypes.length > 0 && this.elemTypes[0] == 15) {
                    this.bufferParser.nextToken();
                }
            }
            catch (IOException iOException) {
                throw new TException((Throwable)iOException);
            }
        }

        @Override
        JsonParser parser() {
            return this.bufferParser;
        }

        int listSize() {
            return this.elemTypes.length;
        }

        byte[] tTypes() {
            return this.elemTypes;
        }

        @Override
        Object getNextItem() throws TException {
            try {
                JsonToken jsonToken = this.bufferParser.nextToken();
                return jsonToken;
            }
            catch (IOException iOException) {
                throw new TException((Throwable)iOException);
            }
        }

        @Override
        byte valueTType() throws TException {
            throw new IllegalStateException("valueTType shouldn't be called on array read contexts");
        }
    }

    private static class MapReadContext
    extends ReadContext {
        private final JsonParser jsonParser;
        private final JsonParser bufferParser;
        private int fieldCount;
        private int valueCount;
        private final byte[] valueTypes;

        MapReadContext(JsonParser jsonParser) throws TException {
            ArrayList<Byte> arrayList = new ArrayList<Byte>();
            this.jsonParser = jsonParser;
            JsonToken jsonToken = this.jsonParser.getCurrentToken();
            if (jsonToken != JsonToken.START_OBJECT) {
                try {
                    jsonToken = this.jsonParser.nextToken();
                }
                catch (IOException iOException) {
                    throw new TException((Throwable)iOException);
                }
                if (jsonToken != JsonToken.START_OBJECT) {
                    throw new TException("Map read expecting start map, got: " + jsonToken);
                }
            }
            try {
                TokenBuffer tokenBuffer = new TokenBuffer(null);
                tokenBuffer.copyCurrentEvent(this.jsonParser);
                this.valueCount = 0;
                this.fieldCount = 0;
                int n = 0;
                JsonToken jsonToken2 = null;
                boolean bl = true;
                boolean bl2 = false;
                while (!bl2) {
                    jsonToken2 = this.jsonParser.nextToken();
                    tokenBuffer.copyCurrentEvent(this.jsonParser);
                    if (bl) {
                        switch (jsonToken2) {
                            case END_OBJECT: {
                                if (n != 0) break;
                                bl2 = true;
                                break;
                            }
                            case FIELD_NAME: {
                                ++this.fieldCount;
                                break;
                            }
                            default: {
                                throw new TException("Map read expected field name, got: " + jsonToken2);
                            }
                        }
                        bl = false;
                        continue;
                    }
                    if (n == 0 && jsonToken2 != JsonToken.END_ARRAY && jsonToken2 != JsonToken.END_OBJECT) {
                        arrayList.add(TReadableJSONProtocol.getElemTypeFromToken(jsonToken2));
                    }
                    switch (jsonToken2) {
                        case START_OBJECT: {
                            if (n == 0) {
                                ++this.valueCount;
                            }
                            ++n;
                            break;
                        }
                        case START_ARRAY: {
                            if (n == 0) {
                                ++this.valueCount;
                            }
                            ++n;
                            break;
                        }
                        case END_OBJECT: {
                            --n;
                            break;
                        }
                        case END_ARRAY: {
                            --n;
                            break;
                        }
                        default: {
                            if (n != 0) break;
                            ++this.valueCount;
                        }
                    }
                    if (n != 0) continue;
                    bl = true;
                }
                this.valueTypes = TReadableJSONProtocol.toByteArray(arrayList);
                this.bufferParser = tokenBuffer.asParser();
                this.bufferParser.nextToken();
            }
            catch (IOException iOException) {
                throw new TException((Throwable)iOException);
            }
            if (this.fieldCount != this.valueCount) {
                throw new TException("Map read got different number of fields than values: " + this.fieldCount + " != " + this.valueCount);
            }
        }

        @Override
        JsonParser parser() {
            return this.bufferParser;
        }

        int mapSize() throws TException {
            return this.fieldCount;
        }

        byte[] valueTTypes() {
            return this.valueTypes;
        }

        @Override
        Object getNextItem() throws TException {
            try {
                JsonToken jsonToken = this.bufferParser.nextToken();
                return jsonToken;
            }
            catch (IOException iOException) {
                throw new TException((Throwable)iOException);
            }
        }

        @Override
        byte valueTType() throws TException {
            return 13;
        }
    }

    private static class ObjectReadContext
    extends ReadContext {
        private final JsonParser jsonParser;
        private String currentKey = null;
        private JsonToken currentValueToken = null;

        ObjectReadContext(JsonParser jsonParser) throws TException {
            this.jsonParser = jsonParser;
            JsonToken jsonToken = this.jsonParser.getCurrentToken();
            if (jsonToken != JsonToken.START_OBJECT) {
                try {
                    jsonToken = this.jsonParser.nextToken();
                }
                catch (IOException iOException) {
                    throw new TException((Throwable)iOException);
                }
                if (jsonToken != JsonToken.START_OBJECT) {
                    throw new TException("Object read expecting start object, got: " + jsonToken);
                }
            }
        }

        @Override
        JsonParser parser() {
            return this.jsonParser;
        }

        @Override
        void contextPopped() throws TException {
            JsonToken jsonToken = this.jsonParser.getCurrentToken();
            if (jsonToken != JsonToken.END_OBJECT) {
                throw new TException("Object read expecting end object, got: " + jsonToken);
            }
        }

        @Override
        void contextRestored() throws TException {
            this.currentKey = null;
        }

        @Override
        Object getNextItem() throws TException {
            try {
                if (this.currentKey == null) {
                    JsonToken jsonToken = this.jsonParser.nextToken();
                    if (jsonToken == JsonToken.END_OBJECT) {
                        this.currentKey = null;
                    } else {
                        this.currentKey = this.jsonParser.getCurrentName();
                        this.currentValueToken = this.jsonParser.nextToken();
                        if (jsonToken != JsonToken.FIELD_NAME) {
                            throw new TException("Expecting token field name, got: " + jsonToken);
                        }
                        if (this.currentValueToken == null) {
                            throw new TException("Expecting token value, got null");
                        }
                    }
                    return this.currentKey;
                }
                this.currentKey = null;
                return this.currentValueToken;
            }
            catch (IOException iOException) {
                throw new TException((Throwable)iOException);
            }
        }

        @Override
        byte valueTType() throws TException {
            return TReadableJSONProtocol.getElemTypeFromToken(this.currentValueToken);
        }
    }

    private static abstract class ReadContext {
        private ReadContext() {
        }

        abstract JsonParser parser();

        abstract Object getNextItem() throws TException;

        void contextPopped() throws TException {
        }

        void contextRestored() throws TException {
        }

        abstract byte valueTType() throws TException;
    }

    public static class Factory
    implements TProtocolFactory {
        private final boolean prettyPrint;
        private final boolean bareObjectIds;
        private boolean numbersAsStrings;
        private final JsonParser parser;

        public Factory() {
            this(false, false, false, null);
        }

        public Factory(boolean bl) {
            this(bl, false, false, null);
        }

        public Factory(boolean bl, JsonParser jsonParser) {
            this(bl, false, false, jsonParser);
        }

        public Factory(boolean bl, boolean bl2) {
            this(bl, bl2, false, null);
        }

        public Factory(boolean bl, boolean bl2, boolean bl3) {
            this(bl, bl2, bl3, null);
        }

        public Factory(boolean bl, boolean bl2, JsonParser jsonParser) {
            this(bl, bl2, false, jsonParser);
        }

        public Factory(boolean bl, boolean bl2, boolean bl3, JsonParser jsonParser) {
            this.prettyPrint = bl;
            this.bareObjectIds = bl2;
            this.numbersAsStrings = bl3;
            this.parser = jsonParser;
        }

        private boolean coerceMapKeys() {
            return this.prettyPrint;
        }

        private PrettyPrinter prettyPrinter() {
            return this.prettyPrint ? new DefaultPrettyPrinter() : null;
        }

        public TProtocol getProtocol(TTransport tTransport) {
            return new TReadableJSONProtocol(tTransport, this.prettyPrinter(), this.parser, this.coerceMapKeys(), this.bareObjectIds, this.numbersAsStrings);
        }
    }
}

