/*
 * Decompiled with CFR 0.152.
 */
package io.fsq.spindle.common.thrift.base;

import io.fsq.spindle.common.thrift.base.SerializeDatesAsSeconds;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ThriftDateTimeHelper {
    public static void write(TProtocol tProtocol, DateTime dateTime) throws TException {
        if (tProtocol instanceof SerializeDatesAsSeconds) {
            tProtocol.writeI64(dateTime.getMillis() / 1000L);
        } else {
            tProtocol.writeI64(dateTime.getMillis());
        }
    }

    public static DateTime read(TProtocol tProtocol, long l) throws TException {
        if (tProtocol instanceof SerializeDatesAsSeconds) {
            return new DateTime(l * 1000L, DateTimeZone.UTC);
        }
        return new DateTime(l, DateTimeZone.UTC);
    }
}

