/*
 * Decompiled with CFR 0.152.
 */
package io.fsq.spindle.common.thrift.base;

import io.fsq.spindle.common.thrift.base.EnhancedTField;
import io.fsq.spindle.common.thrift.base.SerializeDatesAsSeconds;
import io.fsq.spindle.common.thrift.base.TTransportOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Stack;
import javax.xml.bind.DatatypeConverter;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.transport.TTransport;

public class TStringProtocol
extends TProtocol
implements SerializeDatesAsSeconds {
    private static final TMessage ANONYMOUS_MESSAGE = new TMessage();
    private static final TStruct ANONYMOUS_STRUCT = new TStruct();
    private static final short UNKNOWN_FIELD_ID = -1;
    private static final byte UNKNOWN_TTYPE = 1;
    private static final TField NO_MORE_FIELDS = new TField("", 0, 0);
    private static final int MAP_CONTEXT = 1;
    private static final int LIST_CONTEXT = 2;
    private boolean bareObjectIds = false;
    private Writer osw = null;
    private Stack<WriteContext> writeContext = new Stack();
    private String enhancedType = null;

    private void writeDelimiter(Writer writer) throws IOException {
        if (!this.writeContext.isEmpty()) {
            WriteContext writeContext = this.writeContext.peek();
            writer.write(writeContext.delimiter());
            writeContext.toggleMapKey();
            writeContext.decrementItemsRemaining();
        }
    }

    private void writeStructDelimiter(Writer writer) throws IOException {
        if (!this.writeContext.isEmpty()) {
            WriteContext writeContext = this.writeContext.peek();
            writer.write(writeContext.structDelimiter());
            writeContext.toggleMapKey();
            writeContext.decrementItemsRemaining();
        }
    }

    private boolean isMapKey() {
        if (this.writeContext.isEmpty()) {
            return false;
        }
        WriteContext writeContext = this.writeContext.peek();
        return writeContext.isMapKey();
    }

    public TStringProtocol(TTransport tTransport) {
        this(tTransport, false);
    }

    public TStringProtocol(TTransport tTransport, boolean bl) {
        super(tTransport);
        this.bareObjectIds = bl;
    }

    private static byte[] toByteArray(ArrayList<Byte> arrayList) {
        int n = arrayList.size();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = arrayList.get(i);
        }
        return byArray;
    }

    public void reset() {
        this.enhancedType = null;
        this.osw = null;
    }

    private void wrapIOException(IOException iOException) throws TException {
        throw new TException("IOException: " + iOException.getMessage());
    }

    public void writeMessageBegin(TMessage tMessage) throws TException {
    }

    public void writeMessageEnd() throws TException {
    }

    public void writeStructBegin(TStruct tStruct) throws TException {
        if (this.osw == null) {
            this.osw = new OutputStreamWriter(new TTransportOutputStream(this.getTransport()));
        }
        try {
            this.osw.write("{ ");
            this.writeContext.push(new StructContext());
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    public void writeStructEnd() throws TException {
        try {
            this.osw.write(" }");
            this.osw.flush();
            this.writeContext.pop();
            this.writeDelimiter(this.osw);
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    public void writeFieldBegin(TField tField) throws TException {
        try {
            this.writeStructDelimiter(this.osw);
            this.osw.write("\"");
            this.osw.write(tField.name);
            this.osw.write("\": ");
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
        if (tField instanceof EnhancedTField) {
            this.enhancedType = ((EnhancedTField)tField).enhancedTypes.get("bson");
        }
    }

    public void writeFieldEnd() throws TException {
    }

    public void writeFieldStop() throws TException {
    }

    public void writeMapBegin(TMap tMap) throws TException {
        try {
            this.osw.write("{ ");
            this.writeContext.push(new MapContext(tMap.size * 2));
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    public void writeMapEnd() throws TException {
        try {
            this.osw.write("}");
            this.writeContext.pop();
            this.writeDelimiter(this.osw);
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    public void writeListBegin(TList tList) throws TException {
        try {
            this.osw.write("[ ");
            this.writeContext.push(new ListContext(tList.size));
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    public void writeListEnd() throws TException {
        try {
            this.osw.write("]");
            this.writeContext.pop();
            this.writeDelimiter(this.osw);
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    public void writeSetBegin(TSet tSet) throws TException {
        try {
            this.osw.write("{ ");
            this.writeContext.push(new ListContext(tSet.size));
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    public void writeSetEnd() throws TException {
        try {
            this.osw.write("}");
            this.writeContext.pop();
            this.writeDelimiter(this.osw);
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    public void writeBool(boolean bl) throws TException {
        try {
            this.osw.write(Boolean.toString(bl));
            this.writeDelimiter(this.osw);
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    public void writeByte(byte by) throws TException {
        try {
            this.osw.write(Byte.toString(by));
            this.writeDelimiter(this.osw);
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    public void writeI16(short s) throws TException {
        try {
            this.osw.write(Short.toString(s));
            this.writeDelimiter(this.osw);
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    public void writeI32(int n) throws TException {
        try {
            this.osw.write(Integer.toString(n));
            this.writeDelimiter(this.osw);
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    public void writeI64(long l) throws TException {
        try {
            this.osw.write(Long.toString(l));
            this.writeDelimiter(this.osw);
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    public void writeDouble(double d) throws TException {
        try {
            this.osw.write(Double.toString(d));
            this.writeDelimiter(this.osw);
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    public void writeString(String string) throws TException {
        try {
            this.osw.write("\"");
            this.osw.write(string);
            this.osw.write("\"");
            this.writeDelimiter(this.osw);
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    public void writeBinary(ByteBuffer byteBuffer) throws TException {
        try {
            byte[] byArray = TBaseHelper.byteBufferToByteArray((ByteBuffer)byteBuffer);
            if (this.isMapKey()) {
                this.osw.write(this.toObjectIdString(byArray));
            } else if ("ObjectId".equals(this.enhancedType)) {
                this.osw.write(this.toObjectIdString(byArray));
            } else {
                this.osw.write(this.toBase64String(byArray));
            }
            this.writeDelimiter(this.osw);
        }
        catch (IOException iOException) {
            this.wrapIOException(iOException);
        }
    }

    private String toObjectIdString(byte[] byArray) {
        String string = DatatypeConverter.printHexBinary((byte[])byArray).toLowerCase();
        if (this.bareObjectIds) {
            return "\"" + string + "\"";
        }
        return "ObjectId(\"" + string + "\")";
    }

    private String toBase64String(byte[] byArray) {
        String string = DatatypeConverter.printBase64Binary((byte[])byArray);
        if (this.bareObjectIds) {
            return "Base64(\"" + string + "\")";
        }
        return "\"" + string + "\"";
    }

    public TMessage readMessageBegin() throws TException {
        return ANONYMOUS_MESSAGE;
    }

    public void readMessageEnd() throws TException {
    }

    public TStruct readStructBegin() throws TException {
        throw new UnsupportedOperationException("TStringProtocol does not support reading");
    }

    public void readStructEnd() throws TException {
    }

    public TField readFieldBegin() throws TException {
        throw new UnsupportedOperationException("TStringProtocol does not support reading");
    }

    public void readFieldEnd() throws TException {
    }

    public TMap readMapBegin() throws TException {
        throw new UnsupportedOperationException("TStringProtocol does not support reading");
    }

    public void readMapEnd() throws TException {
    }

    public TList readListBegin() throws TException {
        throw new UnsupportedOperationException("TStringProtocol does not support reading");
    }

    public void readListEnd() throws TException {
    }

    public TSet readSetBegin() throws TException {
        throw new UnsupportedOperationException("TStringProtocol does not support reading");
    }

    public void readSetEnd() throws TException {
    }

    public boolean readBool() throws TException {
        throw new UnsupportedOperationException("TStringProtocol does not support reading");
    }

    public byte readByte() throws TException {
        throw new UnsupportedOperationException("TStringProtocol does not support reading");
    }

    public short readI16() throws TException {
        throw new UnsupportedOperationException("TStringProtocol does not support reading");
    }

    public int readI32() throws TException {
        throw new UnsupportedOperationException("TStringProtocol does not support reading");
    }

    public long readI64() throws TException {
        throw new UnsupportedOperationException("TStringProtocol does not support reading");
    }

    public double readDouble() throws TException {
        throw new UnsupportedOperationException("TStringProtocol does not support reading");
    }

    public String readString() throws TException {
        throw new UnsupportedOperationException("TStringProtocol does not support reading");
    }

    public ByteBuffer readBinary() throws TException {
        throw new UnsupportedOperationException("TStringProtocol does not support reading");
    }

    public static class Factory
    implements TProtocolFactory {
        private final boolean bareObjectIds;

        public Factory() {
            this(false);
        }

        public Factory(boolean bl) {
            this.bareObjectIds = bl;
        }

        public TProtocol getProtocol(TTransport tTransport) {
            return new TStringProtocol(tTransport, this.bareObjectIds);
        }
    }

    class ListContext
    extends WriteContext {
        public ListContext(int n) {
            this.items = n;
        }

        @Override
        public String delimiter() {
            if (this.items > 1) {
                return ", ";
            }
            return " ";
        }
    }

    class MapContext
    extends WriteContext {
        private boolean _isMapKey;

        public MapContext(int n) {
            this._isMapKey = true;
            this.items = n;
        }

        @Override
        public boolean isMapKey() {
            return this._isMapKey;
        }

        @Override
        public void toggleMapKey() {
            this._isMapKey = !this._isMapKey;
        }

        @Override
        public String delimiter() {
            if (this._isMapKey) {
                return ": ";
            }
            if (this.items > 1) {
                return ", ";
            }
            return " ";
        }
    }

    class StructContext
    extends WriteContext {
        StructContext() {
        }

        @Override
        public String delimiter() {
            return "";
        }

        @Override
        public String structDelimiter() {
            if (this.items == 0) {
                return "";
            }
            return ", ";
        }
    }

    abstract class WriteContext {
        protected int items = 0;

        WriteContext() {
        }

        public int itemsRemaining() {
            return this.items;
        }

        public void decrementItemsRemaining() {
            --this.items;
        }

        public abstract String delimiter();

        public String structDelimiter() {
            return "";
        }

        public boolean isMapKey() {
            return false;
        }

        public void toggleMapKey() {
        }
    }
}

