/*
 * Decompiled with CFR 0.152.
 */
package io.fruitful.ecomerce.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import io.fruitful.ecomerce.dto.MagentoCustomAttribute;
import io.fruitful.ecomerce.dto.MagentoExtensionAttributes;
import io.fruitful.ecomerce.dto.MagentoMediaDto;
import io.fruitful.ecomerce.dto.MagentoStockItem;
import io.fruitful.ecomerce.dto.MagentoVendorInventory;
import io.fruitful.ecomerce.enums.MagentoProductStatus;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.CollectionUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MagentoProduct {
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="sku")
    private String sku;
    @JsonProperty(value="name")
    private String name;
    private Long attributeSetId;
    @JsonProperty(value="price")
    private Double price;
    @JsonProperty(value="status")
    private Long status;
    @JsonProperty(value="visibility")
    private Long visibility;
    private String typeId;
    private String createdAt;
    private String updatedAt;
    @JsonProperty(value="weight")
    private Long weight;
    private MagentoExtensionAttributes magentoExtensionAttributes;
    private List<MagentoCustomAttribute> customAttributes;
    private List<MagentoMediaDto> medias = new ArrayList<MagentoMediaDto>();
    private Boolean soldOut = false;

    @JsonGetter(value="medias")
    public List<MagentoMediaDto> getMedias() {
        return this.medias;
    }

    @JsonSetter(value="media_gallery_entries")
    public void setMedias(List<MagentoMediaDto> medias) {
        for (MagentoMediaDto m : medias) {
            m.setFileUrl(m.getFileUrl());
        }
        this.medias = medias;
    }

    @JsonIgnore
    public boolean outOfStock() {
        if ((long)MagentoProductStatus.Disabled.value() == this.status) {
            return true;
        }
        if (this.magentoExtensionAttributes != null && CollectionUtils.isEmpty(this.magentoExtensionAttributes.getWebsiteIds())) {
            return true;
        }
        if (this.magentoExtensionAttributes != null && this.magentoExtensionAttributes.getStockItem() != null) {
            MagentoStockItem stockItem = this.magentoExtensionAttributes.getStockItem();
            return Boolean.FALSE.equals(stockItem.getIsInStock()) || stockItem.getMinQty() >= stockItem.getQty();
        }
        return false;
    }

    @JsonGetter(value="attributeSetId")
    public Long getAttributeSetId() {
        return this.attributeSetId;
    }

    @JsonSetter(value="attribute_set_id")
    public void setAttributeSetId(Long attributeSetId) {
        this.attributeSetId = attributeSetId;
    }

    @JsonGetter(value="typeId")
    public String getTypeId() {
        return this.typeId;
    }

    @JsonSetter(value="type_id")
    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    @JsonGetter(value="createdAt")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonSetter(value="created_at")
    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    @JsonGetter(value="updateAt")
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="update_at")
    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    @JsonGetter(value="customAttributes")
    public List<MagentoCustomAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    @JsonSetter(value="custom_attributes")
    public void setCustomAttributes(List<MagentoCustomAttribute> customAttributes) {
        this.customAttributes = customAttributes;
    }

    @JsonGetter(value="magentoExtensionAttributes")
    public MagentoExtensionAttributes getMagentoExtensionAttributes() {
        return this.magentoExtensionAttributes;
    }

    @JsonSetter(value="extension_attributes")
    public void setMagentoExtensionAttributes(MagentoExtensionAttributes magentoExtensionAttributes) {
        this.magentoExtensionAttributes = magentoExtensionAttributes;
    }

    public void setSoldOut(Boolean soldOut) {
        this.soldOut = soldOut;
    }

    public Boolean getSoldOut() {
        if (this.magentoExtensionAttributes == null) {
            return false;
        }
        if (this.magentoExtensionAttributes != null && this.magentoExtensionAttributes.getVendorInventory() != null) {
            MagentoVendorInventory inventory = this.magentoExtensionAttributes.getVendorInventory();
            return inventory.getQty() != null ? inventory.getQty() <= 0 : true;
        }
        return false;
    }

    public Long getId() {
        return this.id;
    }

    public String getSku() {
        return this.sku;
    }

    public String getName() {
        return this.name;
    }

    public Double getPrice() {
        return this.price;
    }

    public Long getStatus() {
        return this.status;
    }

    public Long getVisibility() {
        return this.visibility;
    }

    public Long getWeight() {
        return this.weight;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public void setStatus(Long status) {
        this.status = status;
    }

    public void setVisibility(Long visibility) {
        this.visibility = visibility;
    }

    public void setWeight(Long weight) {
        this.weight = weight;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MagentoProduct)) {
            return false;
        }
        MagentoProduct other = (MagentoProduct)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$sku = this.getSku();
        String other$sku = other.getSku();
        if (this$sku == null ? other$sku != null : !this$sku.equals(other$sku)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Long this$attributeSetId = this.getAttributeSetId();
        Long other$attributeSetId = other.getAttributeSetId();
        if (this$attributeSetId == null ? other$attributeSetId != null : !((Object)this$attributeSetId).equals(other$attributeSetId)) {
            return false;
        }
        Double this$price = this.getPrice();
        Double other$price = other.getPrice();
        if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
            return false;
        }
        Long this$status = this.getStatus();
        Long other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Long this$visibility = this.getVisibility();
        Long other$visibility = other.getVisibility();
        if (this$visibility == null ? other$visibility != null : !((Object)this$visibility).equals(other$visibility)) {
            return false;
        }
        String this$typeId = this.getTypeId();
        String other$typeId = other.getTypeId();
        if (this$typeId == null ? other$typeId != null : !this$typeId.equals(other$typeId)) {
            return false;
        }
        String this$createdAt = this.getCreatedAt();
        String other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) {
            return false;
        }
        String this$updatedAt = this.getUpdatedAt();
        String other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !this$updatedAt.equals(other$updatedAt)) {
            return false;
        }
        Long this$weight = this.getWeight();
        Long other$weight = other.getWeight();
        if (this$weight == null ? other$weight != null : !((Object)this$weight).equals(other$weight)) {
            return false;
        }
        MagentoExtensionAttributes this$magentoExtensionAttributes = this.getMagentoExtensionAttributes();
        MagentoExtensionAttributes other$magentoExtensionAttributes = other.getMagentoExtensionAttributes();
        if (this$magentoExtensionAttributes == null ? other$magentoExtensionAttributes != null : !((Object)this$magentoExtensionAttributes).equals(other$magentoExtensionAttributes)) {
            return false;
        }
        List<MagentoCustomAttribute> this$customAttributes = this.getCustomAttributes();
        List<MagentoCustomAttribute> other$customAttributes = other.getCustomAttributes();
        if (this$customAttributes == null ? other$customAttributes != null : !((Object)this$customAttributes).equals(other$customAttributes)) {
            return false;
        }
        List<MagentoMediaDto> this$medias = this.getMedias();
        List<MagentoMediaDto> other$medias = other.getMedias();
        if (this$medias == null ? other$medias != null : !((Object)this$medias).equals(other$medias)) {
            return false;
        }
        Boolean this$soldOut = this.getSoldOut();
        Boolean other$soldOut = other.getSoldOut();
        return !(this$soldOut == null ? other$soldOut != null : !((Object)this$soldOut).equals(other$soldOut));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MagentoProduct;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $sku = this.getSku();
        result = result * 59 + ($sku == null ? 43 : $sku.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Long $attributeSetId = this.getAttributeSetId();
        result = result * 59 + ($attributeSetId == null ? 43 : ((Object)$attributeSetId).hashCode());
        Double $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        Long $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Long $visibility = this.getVisibility();
        result = result * 59 + ($visibility == null ? 43 : ((Object)$visibility).hashCode());
        String $typeId = this.getTypeId();
        result = result * 59 + ($typeId == null ? 43 : $typeId.hashCode());
        String $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : $createdAt.hashCode());
        String $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : $updatedAt.hashCode());
        Long $weight = this.getWeight();
        result = result * 59 + ($weight == null ? 43 : ((Object)$weight).hashCode());
        MagentoExtensionAttributes $magentoExtensionAttributes = this.getMagentoExtensionAttributes();
        result = result * 59 + ($magentoExtensionAttributes == null ? 43 : ((Object)$magentoExtensionAttributes).hashCode());
        List<MagentoCustomAttribute> $customAttributes = this.getCustomAttributes();
        result = result * 59 + ($customAttributes == null ? 43 : ((Object)$customAttributes).hashCode());
        List<MagentoMediaDto> $medias = this.getMedias();
        result = result * 59 + ($medias == null ? 43 : ((Object)$medias).hashCode());
        Boolean $soldOut = this.getSoldOut();
        result = result * 59 + ($soldOut == null ? 43 : ((Object)$soldOut).hashCode());
        return result;
    }

    public String toString() {
        return "MagentoProduct(id=" + this.getId() + ", sku=" + this.getSku() + ", name=" + this.getName() + ", attributeSetId=" + this.getAttributeSetId() + ", price=" + this.getPrice() + ", status=" + this.getStatus() + ", visibility=" + this.getVisibility() + ", typeId=" + this.getTypeId() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", weight=" + this.getWeight() + ", magentoExtensionAttributes=" + this.getMagentoExtensionAttributes() + ", customAttributes=" + this.getCustomAttributes() + ", medias=" + this.getMedias() + ", soldOut=" + this.getSoldOut() + ")";
    }
}

