/*
 * Decompiled with CFR 0.152.
 */
package io.fruitful.ecomerce;

import io.fruitful.ecomerce.Configuration;
import io.fruitful.ecomerce.Magento;
import io.fruitful.ecomerce.commons.MagentoException;
import io.fruitful.ecomerce.dto.BaseCustomerTokenRequest;
import io.fruitful.ecomerce.dto.MagentoAddProductToCartRequest;
import io.fruitful.ecomerce.dto.MagentoAddProductToCartResponse;
import io.fruitful.ecomerce.dto.MagentoApproveProductResponse;
import io.fruitful.ecomerce.dto.MagentoApproveRejectProductRequest;
import io.fruitful.ecomerce.dto.MagentoCartResponse;
import io.fruitful.ecomerce.dto.MagentoCartTotalsResponse;
import io.fruitful.ecomerce.dto.MagentoCategoryDto;
import io.fruitful.ecomerce.dto.MagentoCategoryResponse;
import io.fruitful.ecomerce.dto.MagentoCategorySearchRequest;
import io.fruitful.ecomerce.dto.MagentoConst;
import io.fruitful.ecomerce.dto.MagentoCountry;
import io.fruitful.ecomerce.dto.MagentoCountryDetail;
import io.fruitful.ecomerce.dto.MagentoEstimateShippingRequest;
import io.fruitful.ecomerce.dto.MagentoMediaDto;
import io.fruitful.ecomerce.dto.MagentoProduct;
import io.fruitful.ecomerce.dto.MagentoProductDetailRequest;
import io.fruitful.ecomerce.dto.MagentoProductRequest;
import io.fruitful.ecomerce.dto.MagentoProductResponse;
import io.fruitful.ecomerce.dto.MagentoProductSearchRequest;
import io.fruitful.ecomerce.dto.MagentoShippingInfo;
import io.fruitful.ecomerce.dto.MagentoShippingInfoRequest;
import io.fruitful.ecomerce.dto.MagentoShippingMethodInfo;
import io.fruitful.ecomerce.dto.MagentoWishlistRequest;
import io.fruitful.ecomerce.dto.MagentoWishlistResponse;
import io.fruitful.ecomerce.dto.RemoveItemCartRequest;
import io.fruitful.ecomerce.proxy.MagentoCartApi;
import io.fruitful.ecomerce.proxy.MagentoCustomerApi;
import io.fruitful.ecomerce.proxy.MagentoInterceptor;
import io.fruitful.ecomerce.proxy.MagentoProductApi;
import io.fruitful.ecomerce.proxy.MagentoWishlistApi;
import io.fruitful.ecomerce.utils.RetrofitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import retrofit2.Response;

public class MagentoImpl
implements Magento {
    private static final Logger log = LogManager.getLogger(MagentoImpl.class);
    private Configuration conf;
    private String customerToken;
    private MagentoCustomerApi magentoCustomerApi;
    private MagentoProductApi magentoProductApi;
    private MagentoProductApi magentoCustomerProductApi;
    private MagentoWishlistApi magentoWishlistApi;
    private MagentoCartApi magentoCartApi;

    public MagentoImpl(Configuration conf, String customerToken) {
        this.conf = conf;
        this.customerToken = customerToken;
        this.init();
    }

    public MagentoImpl(Configuration conf) {
        this.conf = conf;
        this.init();
    }

    public void init() {
        String integrationToken = this.conf.getIntegrationToken();
        String endpoint = this.conf.getEndpoint();
        this.magentoCustomerApi = RetrofitService.createService(MagentoCustomerApi.class, new MagentoInterceptor(integrationToken), endpoint);
        this.magentoProductApi = RetrofitService.createService(MagentoProductApi.class, new MagentoInterceptor(integrationToken), endpoint);
        MagentoInterceptor customerInterceptor = null;
        if (!StringUtils.isEmpty((Object)this.customerToken)) {
            customerInterceptor = new MagentoInterceptor(this.customerToken);
        }
        this.magentoCustomerProductApi = RetrofitService.createService(MagentoProductApi.class, customerInterceptor, endpoint);
        this.magentoWishlistApi = RetrofitService.createService(MagentoWishlistApi.class, customerInterceptor, endpoint);
        this.magentoCartApi = RetrofitService.createService(MagentoCartApi.class, customerInterceptor, endpoint);
    }

    @Override
    public Boolean magentoRemoveItemsCart(RemoveItemCartRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoCartApi.removeItemsCart(request.getBearerToken(), request.getItemId()).execute();
        }
        catch (Exception ex) {
            log.error("removeItemsCart error ", (Throwable)ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (Boolean)RetrofitService.getData(response);
    }

    @Override
    public MagentoCartTotalsResponse magentoGetCartTotals(BaseCustomerTokenRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoCartApi.getCartTotals(request.getBearerToken()).execute();
        }
        catch (Exception ex) {
            log.error("getCartTotals error ", (Throwable)ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (MagentoCartTotalsResponse)RetrofitService.getData(response);
    }

    @Override
    public MagentoCartResponse magentoGetCurrentCart(BaseCustomerTokenRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoCartApi.getCurrentCart(request.getBearerToken()).execute();
        }
        catch (Exception ex) {
            log.error("getCurrentCart error ", (Throwable)ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (MagentoCartResponse)RetrofitService.getData(response);
    }

    @Override
    public String createCart(BaseCustomerTokenRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoCartApi.createCart(request.getBearerToken()).execute();
        }
        catch (Exception ex) {
            log.error("createCart error ", (Throwable)ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (String)RetrofitService.getData(response);
    }

    @Override
    public MagentoAddProductToCartResponse magentoAddProductToCart(MagentoAddProductToCartRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoCartApi.addProductToCart(request.getBearerToken(), request).execute();
        }
        catch (Exception ex) {
            log.error("addProductToCart error ", (Throwable)ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (MagentoAddProductToCartResponse)RetrofitService.getData(response);
    }

    @Override
    public MagentoAddProductToCartResponse magentoUpdateProductCart(MagentoAddProductToCartRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoCartApi.updateProductCart(request.getBearerToken(), request.getCartItem().getItemId(), request).execute();
        }
        catch (Exception ex) {
            log.error("addProductToCart error ", (Throwable)ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (MagentoAddProductToCartResponse)RetrofitService.getData(response);
    }

    @Override
    public List<MagentoCountry> getCountries() throws MagentoException {
        Response response;
        try {
            response = this.magentoCartApi.getCountries().execute();
        }
        catch (Exception ex) {
            log.error("Get countries error ", (Throwable)ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (List)RetrofitService.getData(response);
    }

    @Override
    public MagentoCountryDetail getCountryDetail(String countryId) throws MagentoException {
        Response response;
        try {
            response = this.magentoCartApi.getCountryDetail(countryId).execute();
        }
        catch (Exception ex) {
            log.error("Get countries error ", (Throwable)ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (MagentoCountryDetail)RetrofitService.getData(response);
    }

    @Override
    public List<MagentoShippingMethodInfo> estimateShippingMethods(MagentoEstimateShippingRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoCartApi.estimateShippingMethods(request.getBearerToken(), request).execute();
        }
        catch (Exception ex) {
            log.error("Estimate shipping methods failed.", (Throwable)ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (List)RetrofitService.getData(response);
    }

    @Override
    public MagentoShippingInfo getShippingInfo(MagentoShippingInfoRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoCartApi.getShippingInfo(request.getBearerToken(), request).execute();
        }
        catch (Exception ex) {
            log.error("Get shipping information failed.", (Throwable)ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (MagentoShippingInfo)RetrofitService.getData(response);
    }

    @Override
    public MagentoProductResponse searchProduct(Long customerId, MagentoProductSearchRequest request) throws MagentoException {
        Response response;
        Map<String, String> searchCriteria = this.buildProductCriteria(request);
        if (searchCriteria.isEmpty()) {
            return new MagentoProductResponse();
        }
        try {
            response = this.magentoProductApi.cliqueSearchProduct(customerId, searchCriteria).execute();
        }
        catch (Exception ex) {
            log.error("searchProduct error ", (Throwable)ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        MagentoProductResponse data = (MagentoProductResponse)RetrofitService.getData(response);
        if (data == null) {
            return new MagentoProductResponse();
        }
        this.fixProductMediaUrl(data.getItems());
        return data;
    }

    @Override
    public List<MagentoCategoryDto> getCategory(Long rootCategoryId) throws MagentoException {
        Response response;
        HashMap<String, String> criteria = new HashMap<String, String>();
        if (rootCategoryId == null) {
            rootCategoryId = this.conf.getDefaultCategoryId();
        }
        criteria.put("root_category_id", rootCategoryId.toString());
        try {
            response = this.magentoProductApi.getCategory(criteria).execute();
        }
        catch (Exception ex) {
            log.error("searchProduct error ", (Throwable)ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (List)RetrofitService.getData(response);
    }

    @Override
    public MagentoCategoryResponse listCategory(MagentoCategorySearchRequest request) throws MagentoException {
        Response response;
        Map<String, String> criteria = this.buildCategoryCriteria(request);
        try {
            response = this.magentoProductApi.searchCategory(criteria).execute();
        }
        catch (Exception ex) {
            log.error("searchProduct error ", (Throwable)ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (MagentoCategoryResponse)RetrofitService.getData(response);
    }

    @Override
    public boolean updateProduct(MagentoProductRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoProductApi.updateProduct(request.getProduct().getSku(), request).execute();
        }
        catch (Exception ex) {
            log.error("updateProduct error ", (Throwable)ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        RetrofitService.getData(response);
        return true;
    }

    @Override
    public MagentoProduct getProductDetail(MagentoProductDetailRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoCustomerProductApi.getCustomerProductDetail(request.getSku(), request.getBearerToken()).execute();
        }
        catch (Exception ex) {
            log.error("getProductDetail error ", (Throwable)ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        MagentoProduct data = (MagentoProduct)RetrofitService.getData(response);
        this.fixProductMediaUrl(Collections.singleton(data));
        return data;
    }

    private void fixProductMediaUrl(Collection<MagentoProduct> products) {
        for (MagentoProduct p : products) {
            for (MagentoMediaDto m : p.getMedias()) {
                if (StringUtils.isEmpty((Object)m.getFileUrl()) || m.getFileUrl().contains("http://") || m.getFileUrl().contains("https://")) continue;
                m.setFileUrl(this.conf.getEndpoint() + this.conf.getMediaLocation() + m.getFileUrl());
            }
        }
    }

    private Map<String, String> buildCategoryCriteria(MagentoCategorySearchRequest request) throws MagentoException {
        Long parentId;
        LinkedHashMap<String, String> criteria = new LinkedHashMap<String, String>();
        if (!StringUtils.isEmpty((Object)request.getKeyword())) {
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 0, 0), "name");
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 0, 0), "%25" + request.getKeyword().trim() + "%25");
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 0, 0), "like");
        }
        if (request.getIsActive() != null) {
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 1, 0), "is_active");
            Integer v = MagentoConst.ACTIVE.equals(request.getIsActive()) ? MagentoConst.ACTIVE : MagentoConst.INACTIVE;
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 1, 0), v.toString());
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 1, 0), "eq");
        }
        Long l = parentId = request.getParentId() != null ? request.getParentId() : this.conf.getDefaultCategoryId();
        if (request.getIncludeSubChildren() != null && request.getIncludeSubChildren().booleanValue()) {
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 2, 0), "path");
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 2, 0), "%25" + parentId + "/%25");
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 2, 0), "like");
        } else {
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 2, 0), "parent_id");
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 2, 0), parentId.toString());
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 2, 0), "eq");
        }
        return criteria;
    }

    private Map<String, String> buildProductCriteria(MagentoProductSearchRequest request) throws MagentoException {
        String talentConditionType;
        LinkedHashMap<String, String> criteria = new LinkedHashMap<String, String>();
        String talentField = MagentoConst.APPROVE_STATUS.equals(request.getApprovalStatus()) ? "category_id" : "product_talent";
        String string = talentConditionType = MagentoConst.APPROVE_STATUS.equals(request.getApprovalStatus()) ? "in" : "eq";
        if (!CollectionUtils.isEmpty(request.getUserIds())) {
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 0, 0), talentField);
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 0, 0), String.join((CharSequence)",", request.getUserIds()));
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 0, 0), talentConditionType);
        } else {
            int value = MagentoConst.APPROVE_STATUS.equals(request.getApprovalStatus()) ? 1 : 0;
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 0, 0), "approve");
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 0, 0), Integer.toString(value));
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 0, 0), "eq");
        }
        if (!CollectionUtils.isEmpty(request.getCategoryIds())) {
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 1, 0), "category_id");
            Set categoryIds = request.getCategoryIds().stream().map(Objects::toString).collect(Collectors.toSet());
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 1, 0), String.join((CharSequence)",", categoryIds));
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 1, 0), "in");
        }
        if (!StringUtils.isEmpty((Object)request.getKeyword())) {
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 2, 0), "name");
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 2, 0), "%25" + request.getKeyword().trim() + "%25");
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 2, 0), "like");
        }
        if (request.getStatus() != null) {
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 3, 0), "status");
            String status = request.getStatus().equals(MagentoConst.ENABLE) ? MagentoConst.ENABLE.toString() : MagentoConst.DISABLE.toString();
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 3, 0), status);
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 3, 0), "eq");
        }
        if (!StringUtils.isEmpty((Object)request.getOrderBy()) && !StringUtils.isEmpty((Object)request.getOrderDirection())) {
            criteria.put(String.format("searchCriteria[sortOrders][%s][field]", 0), request.getOrderBy());
            String direction = request.getOrderDirection().equalsIgnoreCase("DESC") ? "DESC" : "ASC";
            criteria.put(String.format("searchCriteria[sortOrders][%s][direction]", 0), direction);
            if (request.getOrderBy().equalsIgnoreCase("created_at")) {
                criteria.put(String.format("searchCriteria[sortOrders][%s][field]", 1), "created_at");
                criteria.put(String.format("searchCriteria[sortOrders][%s][direction]", 1), "DESC");
            }
            if (request.getOrderBy().equalsIgnoreCase("price")) {
                criteria.put(String.format("searchCriteria[sortOrders][%s][field]", 10), "price");
                criteria.put(String.format("searchCriteria[sortOrders][%s][direction]", 10), "ASC");
            }
        } else {
            criteria.put(String.format("searchCriteria[sortOrders][%s][field]", 1), "created_at");
            criteria.put(String.format("searchCriteria[sortOrders][%s][direction]", 1), "DESC");
            criteria.put(String.format("searchCriteria[sortOrders][%s][field]", 10), "price");
            criteria.put(String.format("searchCriteria[sortOrders][%s][direction]", 10), "ASC");
        }
        if (request.getPageIndex() != null && request.getPageSize() != null) {
            criteria.put("searchCriteria[pageSize]", String.valueOf(request.getPageSize()));
            criteria.put("searchCriteria[currentPage]", String.valueOf(request.getPageIndex()));
        }
        return criteria;
    }

    @Override
    public List<MagentoApproveProductResponse> approveProduct(MagentoApproveRejectProductRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoProductApi.approveProduct(request).execute();
        }
        catch (Exception ex) {
            log.error("approveProduct error ", (Throwable)ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (List)RetrofitService.getData(response);
    }

    @Override
    public boolean rejectProduct(MagentoApproveRejectProductRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoProductApi.rejectProduct(request).execute();
        }
        catch (Exception ex) {
            log.error("rejectProduct error ", (Throwable)ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (Boolean)RetrofitService.getData(response);
    }

    @Override
    public boolean addFromCart(MagentoWishlistRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoWishlistApi.addFromCart(request.getBearerToken(), request).execute();
        }
        catch (Exception ex) {
            log.error("Error was occurred when add product to from cart to wish list.", (Throwable)ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (Boolean)RetrofitService.getData(response);
    }

    @Override
    public boolean addFromShop(MagentoWishlistRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoWishlistApi.addFromShop(request.getBearerToken(), request).execute();
        }
        catch (Exception ex) {
            log.error("Error was occurred when add product from shop page to wish list.", (Throwable)ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (Boolean)RetrofitService.getData(response);
    }

    @Override
    public boolean remove(MagentoWishlistRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoWishlistApi.remove(request.getBearerToken(), request.getSku()).execute();
        }
        catch (Exception ex) {
            log.error("Error was occurred when remove product from wish list.", (Throwable)ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (Boolean)RetrofitService.getData(response);
    }

    @Override
    public MagentoWishlistResponse list(MagentoWishlistRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoWishlistApi.list(request.getBearerToken()).execute();
        }
        catch (Exception ex) {
            log.error("Error was occurred when displaying wish list.", (Throwable)ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        MagentoProductResponse data = (MagentoProductResponse)RetrofitService.getData(response);
        MagentoWishlistResponse wishlistResponse = new MagentoWishlistResponse();
        wishlistResponse.setItems(data != null ? data.getItems() : new ArrayList<MagentoProduct>());
        wishlistResponse.setTotalCount(data != null ? data.getTotalCount() : 0L);
        return wishlistResponse;
    }

    @Override
    public boolean moveAllToCart(MagentoWishlistRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoWishlistApi.moveAllToCart(request.getBearerToken()).execute();
        }
        catch (Exception ex) {
            log.error("Error was occurred when move all wishlist items to cart.", (Throwable)ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (Boolean)RetrofitService.getData(response);
    }

    @Override
    public boolean removeAll(MagentoWishlistRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoWishlistApi.removeAll(request.getBearerToken()).execute();
        }
        catch (Exception ex) {
            log.error("Error was occurred when remove all wishlist items.", (Throwable)ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (Boolean)RetrofitService.getData(response);
    }

    @Override
    public boolean addToCartFromWishlist(MagentoWishlistRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoWishlistApi.addToCartFromWishlist(request.getBearerToken(), request).execute();
        }
        catch (Exception ex) {
            log.error("Error was occurred while add product to cart from wishlist.", (Throwable)ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (Boolean)RetrofitService.getData(response);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public String getCustomerToken() {
        return this.customerToken;
    }

    public MagentoCustomerApi getMagentoCustomerApi() {
        return this.magentoCustomerApi;
    }

    public MagentoProductApi getMagentoProductApi() {
        return this.magentoProductApi;
    }

    public MagentoProductApi getMagentoCustomerProductApi() {
        return this.magentoCustomerProductApi;
    }

    public MagentoWishlistApi getMagentoWishlistApi() {
        return this.magentoWishlistApi;
    }

    public MagentoCartApi getMagentoCartApi() {
        return this.magentoCartApi;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public void setCustomerToken(String customerToken) {
        this.customerToken = customerToken;
    }

    public void setMagentoCustomerApi(MagentoCustomerApi magentoCustomerApi) {
        this.magentoCustomerApi = magentoCustomerApi;
    }

    public void setMagentoProductApi(MagentoProductApi magentoProductApi) {
        this.magentoProductApi = magentoProductApi;
    }

    public void setMagentoCustomerProductApi(MagentoProductApi magentoCustomerProductApi) {
        this.magentoCustomerProductApi = magentoCustomerProductApi;
    }

    public void setMagentoWishlistApi(MagentoWishlistApi magentoWishlistApi) {
        this.magentoWishlistApi = magentoWishlistApi;
    }

    public void setMagentoCartApi(MagentoCartApi magentoCartApi) {
        this.magentoCartApi = magentoCartApi;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MagentoImpl)) {
            return false;
        }
        MagentoImpl other = (MagentoImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Configuration this$conf = this.getConf();
        Configuration other$conf = other.getConf();
        if (this$conf == null ? other$conf != null : !((Object)this$conf).equals(other$conf)) {
            return false;
        }
        String this$customerToken = this.getCustomerToken();
        String other$customerToken = other.getCustomerToken();
        if (this$customerToken == null ? other$customerToken != null : !this$customerToken.equals(other$customerToken)) {
            return false;
        }
        MagentoCustomerApi this$magentoCustomerApi = this.getMagentoCustomerApi();
        MagentoCustomerApi other$magentoCustomerApi = other.getMagentoCustomerApi();
        if (this$magentoCustomerApi == null ? other$magentoCustomerApi != null : !this$magentoCustomerApi.equals(other$magentoCustomerApi)) {
            return false;
        }
        MagentoProductApi this$magentoProductApi = this.getMagentoProductApi();
        MagentoProductApi other$magentoProductApi = other.getMagentoProductApi();
        if (this$magentoProductApi == null ? other$magentoProductApi != null : !this$magentoProductApi.equals(other$magentoProductApi)) {
            return false;
        }
        MagentoProductApi this$magentoCustomerProductApi = this.getMagentoCustomerProductApi();
        MagentoProductApi other$magentoCustomerProductApi = other.getMagentoCustomerProductApi();
        if (this$magentoCustomerProductApi == null ? other$magentoCustomerProductApi != null : !this$magentoCustomerProductApi.equals(other$magentoCustomerProductApi)) {
            return false;
        }
        MagentoWishlistApi this$magentoWishlistApi = this.getMagentoWishlistApi();
        MagentoWishlistApi other$magentoWishlistApi = other.getMagentoWishlistApi();
        if (this$magentoWishlistApi == null ? other$magentoWishlistApi != null : !this$magentoWishlistApi.equals(other$magentoWishlistApi)) {
            return false;
        }
        MagentoCartApi this$magentoCartApi = this.getMagentoCartApi();
        MagentoCartApi other$magentoCartApi = other.getMagentoCartApi();
        return !(this$magentoCartApi == null ? other$magentoCartApi != null : !this$magentoCartApi.equals(other$magentoCartApi));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MagentoImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Configuration $conf = this.getConf();
        result = result * 59 + ($conf == null ? 43 : ((Object)$conf).hashCode());
        String $customerToken = this.getCustomerToken();
        result = result * 59 + ($customerToken == null ? 43 : $customerToken.hashCode());
        MagentoCustomerApi $magentoCustomerApi = this.getMagentoCustomerApi();
        result = result * 59 + ($magentoCustomerApi == null ? 43 : $magentoCustomerApi.hashCode());
        MagentoProductApi $magentoProductApi = this.getMagentoProductApi();
        result = result * 59 + ($magentoProductApi == null ? 43 : $magentoProductApi.hashCode());
        MagentoProductApi $magentoCustomerProductApi = this.getMagentoCustomerProductApi();
        result = result * 59 + ($magentoCustomerProductApi == null ? 43 : $magentoCustomerProductApi.hashCode());
        MagentoWishlistApi $magentoWishlistApi = this.getMagentoWishlistApi();
        result = result * 59 + ($magentoWishlistApi == null ? 43 : $magentoWishlistApi.hashCode());
        MagentoCartApi $magentoCartApi = this.getMagentoCartApi();
        result = result * 59 + ($magentoCartApi == null ? 43 : $magentoCartApi.hashCode());
        return result;
    }

    public String toString() {
        return "MagentoImpl(conf=" + this.getConf() + ", customerToken=" + this.getCustomerToken() + ", magentoCustomerApi=" + this.getMagentoCustomerApi() + ", magentoProductApi=" + this.getMagentoProductApi() + ", magentoCustomerProductApi=" + this.getMagentoCustomerProductApi() + ", magentoWishlistApi=" + this.getMagentoWishlistApi() + ", magentoCartApi=" + this.getMagentoCartApi() + ")";
    }
}

