/*
 * Decompiled with CFR 0.152.
 */
package io.fruitful.ecomerce;

import io.fruitful.ecomerce.Configuration;
import io.fruitful.ecomerce.Magento;
import io.fruitful.ecomerce.MagentoImpl;
import org.springframework.util.StringUtils;

public class MagentoFactory {
    private final Configuration conf;

    public MagentoFactory(Configuration conf) {
        if (conf == null) {
            throw new NullPointerException("configuration cannot be null");
        }
        this.conf = conf;
    }

    public Magento getInstance() {
        String endpoint = this.conf.getEndpoint();
        String integrationToken = this.conf.getIntegrationToken();
        String mediaLocation = this.conf.getMediaLocation();
        if (StringUtils.isEmpty((Object)endpoint) || StringUtils.isEmpty((Object)integrationToken) || StringUtils.isEmpty((Object)mediaLocation)) {
            throw new IllegalStateException("Endpoint or integrationToken or mediaLocation not supplied.");
        }
        return new MagentoImpl(this.conf);
    }

    public Magento getInstance(String customerToken) {
        String endpoint = this.conf.getEndpoint();
        String integrationToken = this.conf.getIntegrationToken();
        String mediaLocation = this.conf.getMediaLocation();
        if (StringUtils.isEmpty((Object)endpoint) || StringUtils.isEmpty((Object)integrationToken) || StringUtils.isEmpty((Object)customerToken) || StringUtils.isEmpty((Object)mediaLocation)) {
            throw new IllegalStateException("Endpoint or integrationToken or customerToken or mediaLocation not supplied.");
        }
        return new MagentoImpl(this.conf, customerToken);
    }
}

