/*
 * Decompiled with CFR 0.152.
 */
package io.fruitful.ecomerce.magento;

import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import io.fruitful.ecomerce.Configuration;
import io.fruitful.ecomerce.commons.MagentoException;
import io.fruitful.ecomerce.dto.BaseCustomerTokenRequest;
import io.fruitful.ecomerce.dto.MagentoAddProductToCartRequest;
import io.fruitful.ecomerce.dto.MagentoAddProductToCartResponse;
import io.fruitful.ecomerce.dto.MagentoCartResponse;
import io.fruitful.ecomerce.dto.MagentoCartTotalsResponse;
import io.fruitful.ecomerce.dto.MagentoCategorySearchRequest;
import io.fruitful.ecomerce.dto.MagentoConst;
import io.fruitful.ecomerce.dto.MagentoCountry;
import io.fruitful.ecomerce.dto.MagentoCountryDetail;
import io.fruitful.ecomerce.dto.MagentoEstimateShippingRequest;
import io.fruitful.ecomerce.dto.MagentoMediaDto;
import io.fruitful.ecomerce.dto.MagentoProduct;
import io.fruitful.ecomerce.dto.MagentoProductDetailRequest;
import io.fruitful.ecomerce.dto.MagentoProductResponse;
import io.fruitful.ecomerce.dto.MagentoProductSearchRequest;
import io.fruitful.ecomerce.dto.MagentoShippingInfo;
import io.fruitful.ecomerce.dto.MagentoShippingInfoRequest;
import io.fruitful.ecomerce.dto.MagentoShippingMethodInfo;
import io.fruitful.ecomerce.dto.MagentoWishlistRequest;
import io.fruitful.ecomerce.dto.MagentoWishlistResponse;
import io.fruitful.ecomerce.dto.RemoveItemCartRequest;
import io.fruitful.ecomerce.magento.MagentoCustomer;
import io.fruitful.ecomerce.proxy.MagentoCartApi;
import io.fruitful.ecomerce.proxy.MagentoInterceptor;
import io.fruitful.ecomerce.proxy.MagentoProductApi;
import io.fruitful.ecomerce.proxy.MagentoWishlistApi;
import io.fruitful.ecomerce.utils.RetrofitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import retrofit2.Response;

public class MagentoCustomerImpl
implements MagentoCustomer {
    private static final Logger log = LoggerFactory.getLogger(MagentoCustomerImpl.class);
    private final Configuration conf;
    private String customerToken;
    private MagentoProductApi magentoCustomerProductApi;
    private MagentoWishlistApi magentoWishlistApi;
    private MagentoCartApi magentoCartApi;

    public MagentoCustomerImpl(Configuration conf, String customerToken) {
        this.conf = conf;
        this.customerToken = customerToken;
        this.init();
    }

    public void init() {
        if (StringUtils.isEmpty((CharSequence)this.customerToken)) {
            throw new NullPointerException("customerToken cannot be null");
        }
        String endpoint = this.conf.getEndpoint();
        MagentoInterceptor customerInterceptor = new MagentoInterceptor(this.customerToken);
        this.magentoCustomerProductApi = RetrofitService.createService(MagentoProductApi.class, customerInterceptor, endpoint);
        this.magentoWishlistApi = RetrofitService.createService(MagentoWishlistApi.class, customerInterceptor, endpoint);
        this.magentoCartApi = RetrofitService.createService(MagentoCartApi.class, customerInterceptor, endpoint);
    }

    @Override
    public Boolean magentoRemoveItemsCart(RemoveItemCartRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoCartApi.removeItemsCart(this.customerToken, request.getItemId()).execute();
        }
        catch (Exception ex) {
            log.error("removeItemsCart error ", ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (Boolean)RetrofitService.getData(response);
    }

    @Override
    public MagentoCartTotalsResponse magentoGetCartTotals(BaseCustomerTokenRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoCartApi.getCartTotals(this.customerToken).execute();
        }
        catch (Exception ex) {
            log.error("getCartTotals error ", ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (MagentoCartTotalsResponse)RetrofitService.getData(response);
    }

    @Override
    public MagentoCartResponse magentoGetCurrentCart(BaseCustomerTokenRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoCartApi.getCurrentCart(this.customerToken).execute();
        }
        catch (Exception ex) {
            log.error("getCurrentCart error ", ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (MagentoCartResponse)RetrofitService.getData(response);
    }

    @Override
    public String createCart() throws MagentoException {
        Response response;
        try {
            response = this.magentoCartApi.createCart(this.customerToken).execute();
        }
        catch (Exception ex) {
            log.error("createCart error ", ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (String)RetrofitService.getData(response);
    }

    @Override
    public MagentoAddProductToCartResponse magentoAddProductToCart(MagentoAddProductToCartRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoCartApi.addProductToCart(this.customerToken, request).execute();
        }
        catch (Exception ex) {
            log.error("addProductToCart error ", ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (MagentoAddProductToCartResponse)RetrofitService.getData(response);
    }

    @Override
    public MagentoAddProductToCartResponse magentoUpdateProductCart(MagentoAddProductToCartRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoCartApi.updateProductCart(this.customerToken, request.getCartItem().getItemId(), request).execute();
        }
        catch (Exception ex) {
            log.error("addProductToCart error ", ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (MagentoAddProductToCartResponse)RetrofitService.getData(response);
    }

    @Override
    public List<MagentoCountry> getCountries() throws MagentoException {
        Response response;
        try {
            response = this.magentoCartApi.getCountries().execute();
        }
        catch (Exception ex) {
            log.error("Get countries error ", ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (List)RetrofitService.getData(response);
    }

    @Override
    public MagentoCountryDetail getCountryDetail(String countryId) throws MagentoException {
        Response response;
        try {
            response = this.magentoCartApi.getCountryDetail(countryId).execute();
        }
        catch (Exception ex) {
            log.error("Get countries error ", ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (MagentoCountryDetail)RetrofitService.getData(response);
    }

    @Override
    public List<MagentoShippingMethodInfo> estimateShippingMethods(MagentoEstimateShippingRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoCartApi.estimateShippingMethods(this.customerToken, request).execute();
        }
        catch (Exception ex) {
            log.error("Estimate shipping methods failed.", ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (List)RetrofitService.getData(response);
    }

    @Override
    public MagentoShippingInfo getShippingInfo(MagentoShippingInfoRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoCartApi.getShippingInfo(this.customerToken, request).execute();
        }
        catch (Exception ex) {
            log.error("Get shipping information failed.", ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (MagentoShippingInfo)RetrofitService.getData(response);
    }

    @Override
    public MagentoProduct getProductDetail(MagentoProductDetailRequest request) throws MagentoException {
        Response response = null;
        try {
            if (!StringUtils.isEmpty((CharSequence)this.customerToken)) {
                response = this.magentoCustomerProductApi.getCustomerProductDetail(request.getSku(), this.customerToken).execute();
            }
        }
        catch (Exception ex) {
            log.error("getProductDetail error ", ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        MagentoProduct data = (MagentoProduct)RetrofitService.getData(response);
        this.fixProductMediaUrl(Collections.singleton(data));
        return data;
    }

    private void fixProductMediaUrl(Collection<MagentoProduct> products) {
        for (MagentoProduct p : products) {
            for (MagentoMediaDto m : p.getMedias()) {
                if (StringUtils.isEmpty((CharSequence)m.getFileUrl()) || m.getFileUrl().contains("http://") || m.getFileUrl().contains("https://")) continue;
                m.setFileUrl(this.conf.getEndpoint() + this.conf.getMediaLocation() + m.getFileUrl());
            }
        }
    }

    private Map<String, String> buildCategoryCriteria(MagentoCategorySearchRequest request) throws MagentoException {
        Long parentId;
        LinkedHashMap<String, String> criteria = new LinkedHashMap<String, String>();
        if (!StringUtils.isEmpty((CharSequence)request.getKeyword())) {
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 0, 0), "name");
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 0, 0), "%25" + request.getKeyword().trim() + "%25");
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 0, 0), "like");
        }
        if (request.getIsActive() != null) {
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 1, 0), "is_active");
            Integer v = MagentoConst.ACTIVE.equals(request.getIsActive()) ? MagentoConst.ACTIVE : MagentoConst.INACTIVE;
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 1, 0), v.toString());
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 1, 0), "eq");
        }
        Long l = parentId = request.getParentId() != null ? request.getParentId() : this.conf.getDefaultCategoryId();
        if (request.getIncludeSubChildren() != null && request.getIncludeSubChildren().booleanValue()) {
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 2, 0), "path");
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 2, 0), "%25" + parentId + "/%25");
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 2, 0), "like");
        } else {
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 2, 0), "parent_id");
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 2, 0), parentId.toString());
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 2, 0), "eq");
        }
        return criteria;
    }

    private Map<String, String> buildProductCriteria(MagentoProductSearchRequest request) throws MagentoException {
        String talentConditionType;
        LinkedHashMap<String, String> criteria = new LinkedHashMap<String, String>();
        String talentField = MagentoConst.APPROVE_STATUS.equals(request.getApprovalStatus()) ? "category_id" : "product_talent";
        String string = talentConditionType = MagentoConst.APPROVE_STATUS.equals(request.getApprovalStatus()) ? "in" : "eq";
        if (!CollectionUtils.isEmpty(request.getUserIds())) {
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 0, 0), talentField);
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 0, 0), String.join((CharSequence)",", request.getUserIds()));
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 0, 0), talentConditionType);
        } else {
            int value = MagentoConst.APPROVE_STATUS.equals(request.getApprovalStatus()) ? 1 : 0;
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 0, 0), "approve");
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 0, 0), Integer.toString(value));
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 0, 0), "eq");
        }
        if (!CollectionUtils.isEmpty(request.getCategoryIds())) {
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 1, 0), "category_id");
            Set categoryIds = request.getCategoryIds().stream().map(Objects::toString).collect(Collectors.toSet());
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 1, 0), String.join((CharSequence)",", categoryIds));
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 1, 0), "in");
        }
        if (!StringUtils.isEmpty((CharSequence)request.getKeyword())) {
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 2, 0), "name");
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 2, 0), "%25" + request.getKeyword().trim() + "%25");
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 2, 0), "like");
        }
        if (request.getStatus() != null) {
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 3, 0), "status");
            String status = request.getStatus().equals(MagentoConst.ENABLE) ? MagentoConst.ENABLE.toString() : MagentoConst.DISABLE.toString();
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 3, 0), status);
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 3, 0), "eq");
        }
        if (!StringUtils.isEmpty((CharSequence)request.getOrderBy()) && !StringUtils.isEmpty((CharSequence)request.getOrderDirection())) {
            criteria.put(String.format("searchCriteria[sortOrders][%s][field]", 0), request.getOrderBy());
            String direction = request.getOrderDirection().equalsIgnoreCase("DESC") ? "DESC" : "ASC";
            criteria.put(String.format("searchCriteria[sortOrders][%s][direction]", 0), direction);
            if (request.getOrderBy().equalsIgnoreCase("created_at")) {
                criteria.put(String.format("searchCriteria[sortOrders][%s][field]", 1), "created_at");
                criteria.put(String.format("searchCriteria[sortOrders][%s][direction]", 1), "DESC");
            }
            if (request.getOrderBy().equalsIgnoreCase("price")) {
                criteria.put(String.format("searchCriteria[sortOrders][%s][field]", 10), "price");
                criteria.put(String.format("searchCriteria[sortOrders][%s][direction]", 10), "ASC");
            }
        } else {
            criteria.put(String.format("searchCriteria[sortOrders][%s][field]", 1), "created_at");
            criteria.put(String.format("searchCriteria[sortOrders][%s][direction]", 1), "DESC");
            criteria.put(String.format("searchCriteria[sortOrders][%s][field]", 10), "price");
            criteria.put(String.format("searchCriteria[sortOrders][%s][direction]", 10), "ASC");
        }
        if (request.getPageIndex() != null && request.getPageSize() != null) {
            criteria.put("searchCriteria[pageSize]", String.valueOf(request.getPageSize()));
            criteria.put("searchCriteria[currentPage]", String.valueOf(request.getPageIndex()));
        }
        return criteria;
    }

    @Override
    public boolean addFromCart(MagentoWishlistRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoWishlistApi.addFromCart(this.customerToken, request).execute();
        }
        catch (Exception ex) {
            log.error("Error was occurred when add product to from cart to wish list.", ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (Boolean)RetrofitService.getData(response);
    }

    @Override
    public boolean addFromShop(MagentoWishlistRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoWishlistApi.addFromShop(this.customerToken, request).execute();
        }
        catch (Exception ex) {
            log.error("Error was occurred when add product from shop page to wish list.", ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (Boolean)RetrofitService.getData(response);
    }

    @Override
    public boolean remove(MagentoWishlistRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoWishlistApi.remove(this.customerToken, request.getSku()).execute();
        }
        catch (Exception ex) {
            log.error("Error was occurred when remove product from wish list.", ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (Boolean)RetrofitService.getData(response);
    }

    @Override
    public MagentoWishlistResponse list(MagentoWishlistRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoWishlistApi.list(this.customerToken).execute();
        }
        catch (Exception ex) {
            log.error("Error was occurred when displaying wish list.", ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        MagentoProductResponse data = (MagentoProductResponse)RetrofitService.getData(response);
        MagentoWishlistResponse wishlistResponse = new MagentoWishlistResponse();
        wishlistResponse.setItems(data != null ? data.getItems() : new ArrayList<MagentoProduct>());
        wishlistResponse.setTotalCount(data != null ? data.getTotalCount() : 0L);
        return wishlistResponse;
    }

    @Override
    public boolean moveAllToCart(MagentoWishlistRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoWishlistApi.moveAllToCart(this.customerToken).execute();
        }
        catch (Exception ex) {
            log.error("Error was occurred when move all wishlist items to cart.", ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (Boolean)RetrofitService.getData(response);
    }

    @Override
    public boolean removeAll(MagentoWishlistRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoWishlistApi.removeAll(this.customerToken).execute();
        }
        catch (Exception ex) {
            log.error("Error was occurred when remove all wishlist items.", ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (Boolean)RetrofitService.getData(response);
    }

    @Override
    public boolean addToCartFromWishlist(MagentoWishlistRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoWishlistApi.addToCartFromWishlist(this.customerToken, request).execute();
        }
        catch (Exception ex) {
            log.error("Error was occurred while add product to cart from wishlist.", ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (Boolean)RetrofitService.getData(response);
    }
}

