/*
 * Decompiled with CFR 0.152.
 */
package io.fruitful.ecomerce.magento;

import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import io.fruitful.ecomerce.Configuration;
import io.fruitful.ecomerce.commons.MagentoException;
import io.fruitful.ecomerce.dto.MagentoApproveProductResponse;
import io.fruitful.ecomerce.dto.MagentoApproveRejectProductRequest;
import io.fruitful.ecomerce.dto.MagentoCategoryDto;
import io.fruitful.ecomerce.dto.MagentoCategoryResponse;
import io.fruitful.ecomerce.dto.MagentoCategorySearchRequest;
import io.fruitful.ecomerce.dto.MagentoConst;
import io.fruitful.ecomerce.dto.MagentoMediaDto;
import io.fruitful.ecomerce.dto.MagentoProduct;
import io.fruitful.ecomerce.dto.MagentoProductDetailRequest;
import io.fruitful.ecomerce.dto.MagentoProductRequest;
import io.fruitful.ecomerce.dto.MagentoProductResponse;
import io.fruitful.ecomerce.dto.MagentoProductSearchRequest;
import io.fruitful.ecomerce.magento.MagentoAdmin;
import io.fruitful.ecomerce.proxy.MagentoCustomerApi;
import io.fruitful.ecomerce.proxy.MagentoInterceptor;
import io.fruitful.ecomerce.proxy.MagentoProductApi;
import io.fruitful.ecomerce.utils.RetrofitService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import retrofit2.Response;

public class MagentoAdminImpl
implements MagentoAdmin {
    private static final Logger log = LoggerFactory.getLogger(MagentoAdminImpl.class);
    private final Configuration conf;
    private MagentoCustomerApi magentoCustomerApi;
    private MagentoProductApi magentoProductApi;

    public MagentoAdminImpl(Configuration conf) {
        this.conf = conf;
        this.init();
    }

    public void init() {
        String integrationToken = this.conf.getIntegrationToken();
        String endpoint = this.conf.getEndpoint();
        this.magentoCustomerApi = RetrofitService.createService(MagentoCustomerApi.class, new MagentoInterceptor(integrationToken), endpoint);
        this.magentoProductApi = RetrofitService.createService(MagentoProductApi.class, new MagentoInterceptor(integrationToken), endpoint);
    }

    @Override
    public MagentoProductResponse searchProduct(Long customerId, MagentoProductSearchRequest request) throws MagentoException {
        Response response;
        Map<String, String> searchCriteria = this.buildProductCriteria(request);
        if (searchCriteria.isEmpty()) {
            return new MagentoProductResponse();
        }
        try {
            response = this.magentoProductApi.cliqueSearchProduct(customerId, searchCriteria).execute();
        }
        catch (Exception ex) {
            log.error("searchProduct error ", ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        MagentoProductResponse data = (MagentoProductResponse)RetrofitService.getData(response);
        if (data == null) {
            return new MagentoProductResponse();
        }
        this.fixProductMediaUrl(data.getItems());
        return data;
    }

    @Override
    public List<MagentoCategoryDto> getCategory(Long rootCategoryId) throws MagentoException {
        Response response;
        HashMap<String, String> criteria = new HashMap<String, String>();
        if (rootCategoryId == null) {
            rootCategoryId = this.conf.getDefaultCategoryId();
        }
        criteria.put("root_category_id", rootCategoryId.toString());
        try {
            response = this.magentoProductApi.getCategory(criteria).execute();
        }
        catch (Exception ex) {
            log.error("searchProduct error ", ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (List)RetrofitService.getData(response);
    }

    @Override
    public MagentoCategoryResponse listCategory(MagentoCategorySearchRequest request) throws MagentoException {
        Response response;
        Map<String, String> criteria = this.buildCategoryCriteria(request);
        try {
            response = this.magentoProductApi.searchCategory(criteria).execute();
        }
        catch (Exception ex) {
            log.error("searchProduct error ", ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (MagentoCategoryResponse)RetrofitService.getData(response);
    }

    @Override
    public boolean updateProduct(MagentoProductRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoProductApi.updateProduct(request.getProduct().getSku(), request).execute();
        }
        catch (Exception ex) {
            log.error("updateProduct error ", ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        RetrofitService.getData(response);
        return true;
    }

    @Override
    public MagentoProduct getProductDetail(MagentoProductDetailRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoProductApi.getProductDetail(request.getSku()).execute();
        }
        catch (Exception ex) {
            log.error("getProductDetail error ", ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        MagentoProduct data = (MagentoProduct)RetrofitService.getData(response);
        this.fixProductMediaUrl(Collections.singleton(data));
        return data;
    }

    private void fixProductMediaUrl(Collection<MagentoProduct> products) {
        for (MagentoProduct p : products) {
            for (MagentoMediaDto m : p.getMedias()) {
                if (StringUtils.isEmpty((CharSequence)m.getFileUrl()) || m.getFileUrl().contains("http://") || m.getFileUrl().contains("https://")) continue;
                m.setFileUrl(this.conf.getEndpoint() + this.conf.getMediaLocation() + m.getFileUrl());
            }
        }
    }

    private Map<String, String> buildCategoryCriteria(MagentoCategorySearchRequest request) throws MagentoException {
        Long parentId;
        LinkedHashMap<String, String> criteria = new LinkedHashMap<String, String>();
        if (!StringUtils.isEmpty((CharSequence)request.getKeyword())) {
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 0, 0), "name");
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 0, 0), "%25" + request.getKeyword().trim() + "%25");
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 0, 0), "like");
        }
        if (request.getIsActive() != null) {
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 1, 0), "is_active");
            Integer v = MagentoConst.ACTIVE.equals(request.getIsActive()) ? MagentoConst.ACTIVE : MagentoConst.INACTIVE;
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 1, 0), v.toString());
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 1, 0), "eq");
        }
        Long l = parentId = request.getParentId() != null ? request.getParentId() : this.conf.getDefaultCategoryId();
        if (request.getIncludeSubChildren() != null && request.getIncludeSubChildren().booleanValue()) {
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 2, 0), "path");
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 2, 0), "%25" + parentId + "/%25");
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 2, 0), "like");
        } else {
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 2, 0), "parent_id");
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 2, 0), parentId.toString());
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 2, 0), "eq");
        }
        return criteria;
    }

    private Map<String, String> buildProductCriteria(MagentoProductSearchRequest request) throws MagentoException {
        String talentConditionType;
        LinkedHashMap<String, String> criteria = new LinkedHashMap<String, String>();
        String talentField = MagentoConst.APPROVE_STATUS.equals(request.getApprovalStatus()) ? "category_id" : "product_talent";
        String string = talentConditionType = MagentoConst.APPROVE_STATUS.equals(request.getApprovalStatus()) ? "in" : "eq";
        if (!CollectionUtils.isEmpty(request.getUserIds())) {
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 0, 0), talentField);
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 0, 0), String.join((CharSequence)",", request.getUserIds()));
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 0, 0), talentConditionType);
        } else {
            int value = MagentoConst.APPROVE_STATUS.equals(request.getApprovalStatus()) ? 1 : 0;
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 0, 0), "approve");
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 0, 0), Integer.toString(value));
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 0, 0), "eq");
        }
        if (!CollectionUtils.isEmpty(request.getCategoryIds())) {
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 1, 0), "category_id");
            Set categoryIds = request.getCategoryIds().stream().map(Objects::toString).collect(Collectors.toSet());
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 1, 0), String.join((CharSequence)",", categoryIds));
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 1, 0), "in");
        }
        if (!StringUtils.isEmpty((CharSequence)request.getKeyword())) {
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 2, 0), "name");
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 2, 0), "%25" + request.getKeyword().trim() + "%25");
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 2, 0), "like");
        }
        if (request.getStatus() != null) {
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][field]", 3, 0), "status");
            String status = request.getStatus().equals(MagentoConst.ENABLE) ? MagentoConst.ENABLE.toString() : MagentoConst.DISABLE.toString();
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][value]", 3, 0), status);
            criteria.put(String.format("searchCriteria[filter_groups][%s][filters][%s][condition_type]", 3, 0), "eq");
        }
        if (!StringUtils.isEmpty((CharSequence)request.getOrderBy()) && !StringUtils.isEmpty((CharSequence)request.getOrderDirection())) {
            criteria.put(String.format("searchCriteria[sortOrders][%s][field]", 0), request.getOrderBy());
            String direction = request.getOrderDirection().equalsIgnoreCase("DESC") ? "DESC" : "ASC";
            criteria.put(String.format("searchCriteria[sortOrders][%s][direction]", 0), direction);
            if (request.getOrderBy().equalsIgnoreCase("created_at")) {
                criteria.put(String.format("searchCriteria[sortOrders][%s][field]", 1), "created_at");
                criteria.put(String.format("searchCriteria[sortOrders][%s][direction]", 1), "DESC");
            }
            if (request.getOrderBy().equalsIgnoreCase("price")) {
                criteria.put(String.format("searchCriteria[sortOrders][%s][field]", 10), "price");
                criteria.put(String.format("searchCriteria[sortOrders][%s][direction]", 10), "ASC");
            }
        } else {
            criteria.put(String.format("searchCriteria[sortOrders][%s][field]", 1), "created_at");
            criteria.put(String.format("searchCriteria[sortOrders][%s][direction]", 1), "DESC");
            criteria.put(String.format("searchCriteria[sortOrders][%s][field]", 10), "price");
            criteria.put(String.format("searchCriteria[sortOrders][%s][direction]", 10), "ASC");
        }
        if (request.getPageIndex() != null && request.getPageSize() != null) {
            criteria.put("searchCriteria[pageSize]", String.valueOf(request.getPageSize()));
            criteria.put("searchCriteria[currentPage]", String.valueOf(request.getPageIndex()));
        }
        return criteria;
    }

    @Override
    public List<MagentoApproveProductResponse> approveProduct(MagentoApproveRejectProductRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoProductApi.approveProduct(request).execute();
        }
        catch (Exception ex) {
            log.error("approveProduct error ", ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (List)RetrofitService.getData(response);
    }

    @Override
    public boolean rejectProduct(MagentoApproveRejectProductRequest request) throws MagentoException {
        Response response;
        try {
            response = this.magentoProductApi.rejectProduct(request).execute();
        }
        catch (Exception ex) {
            log.error("rejectProduct error ", ex);
            throw new MagentoException(1033, ex.getMessage());
        }
        return (Boolean)RetrofitService.getData(response);
    }
}

