/*
 * Decompiled with CFR 0.152.
 */
package io.fruitful.ecomerce.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import io.fruitful.ecomerce.dto.MagentoCustomAttribute;
import io.fruitful.ecomerce.dto.MagentoExtensionAttributes;
import io.fruitful.ecomerce.dto.MagentoMediaDto;
import io.fruitful.ecomerce.dto.MagentoStockItem;
import io.fruitful.ecomerce.dto.MagentoVendorInventory;
import io.fruitful.ecomerce.enums.MagentoProductStatus;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MagentoProduct {
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="sku")
    private String sku;
    @JsonProperty(value="name")
    private String name;
    private Long attributeSetId;
    @JsonProperty(value="price")
    private Double price;
    @JsonProperty(value="status")
    private Long status;
    @JsonProperty(value="visibility")
    private Long visibility;
    private String typeId;
    private String createdAt;
    private String updatedAt;
    @JsonProperty(value="weight")
    private Long weight;
    private MagentoExtensionAttributes magentoExtensionAttributes;
    private List<MagentoCustomAttribute> customAttributes;
    private List<MagentoMediaDto> medias = new ArrayList<MagentoMediaDto>();
    private Boolean soldOut = false;

    @JsonGetter(value="medias")
    public List<MagentoMediaDto> getMedias() {
        return this.medias;
    }

    @JsonSetter(value="media_gallery_entries")
    public void setMedias(List<MagentoMediaDto> medias) {
        for (MagentoMediaDto m : medias) {
            m.setFileUrl(m.getFileUrl());
        }
        this.medias = medias;
    }

    @JsonIgnore
    public boolean outOfStock() {
        if ((long)MagentoProductStatus.Disabled.value() == this.status) {
            return true;
        }
        if (this.magentoExtensionAttributes != null && CollectionUtils.isEmpty(this.magentoExtensionAttributes.getWebsiteIds())) {
            return true;
        }
        if (this.magentoExtensionAttributes != null && this.magentoExtensionAttributes.getStockItem() != null) {
            MagentoStockItem stockItem = this.magentoExtensionAttributes.getStockItem();
            return Boolean.FALSE.equals(stockItem.getInStock()) || stockItem.getMinQty() >= stockItem.getQty();
        }
        return false;
    }

    @JsonGetter(value="attributeSetId")
    public Long getAttributeSetId() {
        return this.attributeSetId;
    }

    @JsonSetter(value="attribute_set_id")
    public void setAttributeSetId(Long attributeSetId) {
        this.attributeSetId = attributeSetId;
    }

    @JsonGetter(value="typeId")
    public String getTypeId() {
        return this.typeId;
    }

    @JsonSetter(value="type_id")
    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    @JsonGetter(value="createdAt")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonSetter(value="created_at")
    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    @JsonGetter(value="updateAt")
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="update_at")
    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    @JsonGetter(value="customAttributes")
    public List<MagentoCustomAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    @JsonSetter(value="custom_attributes")
    public void setCustomAttributes(List<MagentoCustomAttribute> customAttributes) {
        this.customAttributes = customAttributes;
    }

    @JsonGetter(value="magentoExtensionAttributes")
    public MagentoExtensionAttributes getMagentoExtensionAttributes() {
        return this.magentoExtensionAttributes;
    }

    @JsonSetter(value="extension_attributes")
    public void setMagentoExtensionAttributes(MagentoExtensionAttributes magentoExtensionAttributes) {
        this.magentoExtensionAttributes = magentoExtensionAttributes;
    }

    public void setSoldOut(Boolean soldOut) {
        this.soldOut = soldOut;
    }

    public Boolean getSoldOut() {
        if (this.magentoExtensionAttributes == null) {
            return false;
        }
        if (this.magentoExtensionAttributes != null && this.magentoExtensionAttributes.getVendorInventory() != null) {
            MagentoVendorInventory inventory = this.magentoExtensionAttributes.getVendorInventory();
            return inventory.getQty() != null ? inventory.getQty() <= 0 : true;
        }
        return false;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Double getPrice() {
        return this.price;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public Long getStatus() {
        return this.status;
    }

    public void setStatus(Long status) {
        this.status = status;
    }

    public Long getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Long visibility) {
        this.visibility = visibility;
    }

    public Long getWeight() {
        return this.weight;
    }

    public void setWeight(Long weight) {
        this.weight = weight;
    }
}

