/*
 * Decompiled with CFR 0.152.
 */
package io.fruitful.ecomerce;

import io.fruitful.ecomerce.Configuration;
import io.fruitful.ecomerce.magento.MagentoAdmin;
import io.fruitful.ecomerce.magento.MagentoAdminImpl;
import io.fruitful.ecomerce.magento.MagentoCustomer;
import io.fruitful.ecomerce.magento.MagentoCustomerImpl;
import org.apache.commons.lang3.StringUtils;

public class MagentoFactory {
    private final Configuration conf;

    public MagentoFactory(Configuration conf) {
        if (conf == null) {
            throw new NullPointerException("configuration cannot be null");
        }
        this.conf = conf;
    }

    public MagentoAdmin getInstance() {
        String endpoint = this.conf.getEndpoint();
        String integrationToken = this.conf.getIntegrationToken();
        String mediaLocation = this.conf.getMediaLocation();
        if (StringUtils.isEmpty((CharSequence)endpoint) || StringUtils.isEmpty((CharSequence)integrationToken) || StringUtils.isEmpty((CharSequence)mediaLocation)) {
            throw new IllegalStateException("Endpoint or integrationToken or mediaLocation not supplied.");
        }
        return new MagentoAdminImpl(this.conf);
    }

    public MagentoCustomer getInstance(String customerToken) {
        String endpoint = this.conf.getEndpoint();
        String mediaLocation = this.conf.getMediaLocation();
        if (StringUtils.isEmpty((CharSequence)endpoint) || StringUtils.isEmpty((CharSequence)customerToken) || StringUtils.isEmpty((CharSequence)mediaLocation)) {
            throw new IllegalStateException("Endpoint or integrationToken or customerToken or mediaLocation not supplied.");
        }
        return new MagentoCustomerImpl(this.conf, customerToken);
    }
}

