/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.jacoco.tasks;

import java.io.IOException;
import javax.inject.Inject;
import lombok.Generated;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.testing.jacoco.tasks.JacocoBase;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jacoco.core.tools.ExecDumpClient;
import org.jacoco.core.tools.ExecFileLoader;

public class JacocoDump
extends JacocoBase {
    @Internal
    private final WorkerExecutor workerExecutor;
    @Input
    private final Property<Boolean> dump = this.getProject().getObjects().property(Boolean.class).convention((Object)true);
    @Input
    private final Property<Boolean> reset = this.getProject().getObjects().property(Boolean.class).convention((Object)false);
    @Input
    private final Property<Integer> retryCount = this.getProject().getObjects().property(Integer.class).convention((Object)10);
    @Input
    private final Property<String> address = this.getProject().getObjects().property(String.class).convention((Object)"localhost");
    @Input
    private final Property<Integer> port = this.getProject().getObjects().property(Integer.class).convention((Object)6300);
    @OutputFile
    private final RegularFileProperty destfile = this.getProject().getObjects().fileProperty();
    @Input
    private final Property<Boolean> append = this.getProject().getObjects().property(Boolean.class).convention((Object)true);

    @Inject
    public JacocoDump(WorkerExecutor workerExecutor) {
        this.workerExecutor = workerExecutor;
    }

    @TaskAction
    public void dump() {
        if ((Integer)this.port.getOrElse((Object)6300) <= 0) {
            throw new InvalidUserDataException("Invalid port value");
        }
        if (((Boolean)this.dump.getOrElse((Object)true)).booleanValue() && !this.destfile.isPresent()) {
            throw new InvalidUserDataException("Destination file is required when dumping execution data");
        }
        WorkQueue workQueue = this.workerExecutor.classLoaderIsolation(spec -> spec.getClasspath().from(new Object[]{this.getJacocoClasspath()}));
        workQueue.submit(Action.class, jacocoDumpParameters -> {
            jacocoDumpParameters.getDump().set(this.dump);
            jacocoDumpParameters.getReset().set(this.reset);
            jacocoDumpParameters.getRetryCount().set(this.retryCount);
            jacocoDumpParameters.getAddress().set(this.address);
            jacocoDumpParameters.getPort().set(this.port);
            jacocoDumpParameters.getDestfile().set((Provider)this.destfile);
            jacocoDumpParameters.getAppend().set(this.append);
        });
    }

    @Generated
    public WorkerExecutor getWorkerExecutor() {
        return this.workerExecutor;
    }

    @Generated
    public Property<Boolean> getDump() {
        return this.dump;
    }

    @Generated
    public Property<Boolean> getReset() {
        return this.reset;
    }

    @Generated
    public Property<Integer> getRetryCount() {
        return this.retryCount;
    }

    @Generated
    public Property<String> getAddress() {
        return this.address;
    }

    @Generated
    public Property<Integer> getPort() {
        return this.port;
    }

    @Generated
    public RegularFileProperty getDestfile() {
        return this.destfile;
    }

    @Generated
    public Property<Boolean> getAppend() {
        return this.append;
    }

    static abstract class Action
    implements WorkAction<JacocoDumpParameters> {
        Action() {
        }

        public void execute() {
            ExecDumpClient client = new ExecDumpClient();
            client.setDump(((Boolean)((JacocoDumpParameters)this.getParameters()).getDump().getOrElse((Object)false)).booleanValue());
            client.setReset(((Boolean)((JacocoDumpParameters)this.getParameters()).getReset().getOrElse((Object)false)).booleanValue());
            client.setRetryCount(((Integer)((JacocoDumpParameters)this.getParameters()).getRetryCount().getOrElse((Object)0)).intValue());
            try {
                ExecFileLoader loader = client.dump((String)((JacocoDumpParameters)this.getParameters()).getAddress().get(), ((Integer)((JacocoDumpParameters)this.getParameters()).getPort().get()).intValue());
                if (((Boolean)((JacocoDumpParameters)this.getParameters()).getDump().getOrElse((Object)false)).booleanValue()) {
                    loader.save(((RegularFile)((JacocoDumpParameters)this.getParameters()).getDestfile().get()).getAsFile(), ((Boolean)((JacocoDumpParameters)this.getParameters()).getAppend().get()).booleanValue());
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }
    }

    static interface JacocoDumpParameters
    extends WorkParameters {
        public Property<Boolean> getDump();

        public Property<Boolean> getReset();

        public Property<Integer> getRetryCount();

        public Property<String> getAddress();

        public Property<Integer> getPort();

        public RegularFileProperty getDestfile();

        public Property<Boolean> getAppend();
    }
}

