/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.jacoco;

import java.io.File;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.reporting.Report;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.testing.Test;
import org.gradle.testing.jacoco.plugins.JacocoPlugin;
import org.gradle.testing.jacoco.plugins.JacocoPluginExtension;
import org.gradle.testing.jacoco.tasks.JacocoReport;

public class AggregateJacocoReportPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(JacocoPlugin.class);
        project.getTasks().register("aggregateJacocoReport", JacocoReport.class, reportTask -> {
            reportTask.setGroup("verification");
            reportTask.setDescription(String.format("Generates aggregated code coverage report for the %s project.", project.getPath()));
            project.allprojects(subproject -> {
                subproject.getPlugins().withType(JavaPlugin.class, javaPlugin -> {
                    SourceSetContainer sourceSets = ((JavaPluginConvention)subproject.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
                    SourceSet main = (SourceSet)sourceSets.getByName("main");
                    reportTask.sourceSets(new SourceSet[]{main});
                });
                subproject.getTasks().withType(Test.class).forEach(xva$0 -> reportTask.executionData(new Task[]{xva$0}));
            });
            JacocoPluginExtension reportingExtension = (JacocoPluginExtension)project.getExtensions().getByType(JacocoPluginExtension.class);
            reportTask.getReports().getHtml().setEnabled(true);
            reportTask.getReports().all(report -> {
                if (report.getOutputType().equals((Object)Report.OutputType.DIRECTORY)) {
                    report.setDestination(project.provider(() -> new File(reportingExtension.getReportsDir(), reportTask.getName() + "/" + report.getName())));
                } else {
                    report.setDestination(project.provider(() -> new File(reportingExtension.getReportsDir(), reportTask.getName() + "/" + reportTask.getName() + "." + report.getName())));
                }
            });
        });
    }
}

