/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.aspectj;

import io.freefair.gradle.plugins.aspectj.AspectJCompileOptions;
import io.freefair.gradle.plugins.aspectj.internal.AspectJCompileSpec;
import io.freefair.gradle.plugins.aspectj.internal.AspectJCompiler;
import java.util.ArrayList;
import lombok.Generated;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.process.internal.JavaExecHandleFactory;

@CacheableTask
public class AspectjCompile
extends AbstractCompile {
    @Classpath
    private final ConfigurableFileCollection aspectjClasspath = this.getProject().getObjects().fileCollection();
    @Nested
    private final CompileOptions options = (CompileOptions)this.getProject().getObjects().newInstance(CompileOptions.class, new Object[0]);
    @Nested
    private final AspectJCompileOptions ajcOptions = (AspectJCompileOptions)((Object)this.getProject().getObjects().newInstance(AspectJCompileOptions.class, new Object[0]));

    @TaskAction
    protected void compile() {
        this.getProject().delete(new Object[]{this.getDestinationDir()});
        AspectJCompileSpec spec = this.createSpec();
        WorkResult result = this.getCompiler().execute(spec);
        this.setDidWork(result.getDidWork());
    }

    private AspectJCompiler getCompiler() {
        return new AspectJCompiler((JavaExecHandleFactory)this.getServices().get(JavaExecHandleFactory.class));
    }

    private AspectJCompileSpec createSpec() {
        AspectJCompileSpec spec = new AspectJCompileSpec();
        spec.setSourceFiles((Iterable)this.getSource());
        spec.setDestinationDir(this.getDestinationDir());
        spec.setWorkingDir(this.getProject().getProjectDir());
        spec.setTempDir(this.getTemporaryDir());
        spec.setCompileClasspath(new ArrayList(this.getClasspath().getFiles()));
        spec.setSourceCompatibility(this.getSourceCompatibility());
        spec.setTargetCompatibility(this.getTargetCompatibility());
        spec.setAspectJClasspath((FileCollection)this.getAspectjClasspath());
        spec.setAspectJCompileOptions(this.getAjcOptions());
        return spec;
    }

    @Generated
    public ConfigurableFileCollection getAspectjClasspath() {
        return this.aspectjClasspath;
    }

    @Generated
    public CompileOptions getOptions() {
        return this.options;
    }

    @Generated
    public AspectJCompileOptions getAjcOptions() {
        return this.ajcOptions;
    }
}

