/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.aspectj;

import io.freefair.gradle.plugins.aspectj.AspectJBasePlugin;
import io.freefair.gradle.plugins.aspectj.AspectjCompile;
import io.freefair.gradle.plugins.aspectj.internal.DefaultAspectjSourceSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.internal.SourceSetUtil;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;

public class AspectJPlugin
implements Plugin<Project> {
    private Project project;

    public void apply(Project project) {
        this.project = project;
        project.getPlugins().apply(AspectJBasePlugin.class);
        project.getPlugins().apply(JavaBasePlugin.class);
        JavaPluginConvention plugin = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        plugin.getSourceSets().all(this::configureSourceSet);
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> {
            SourceSet main = (SourceSet)plugin.getSourceSets().getByName("main");
            SourceSet test = (SourceSet)plugin.getSourceSets().getByName("test");
            DefaultAspectjSourceSet mainAj = (DefaultAspectjSourceSet)new DslObject((Object)main).getConvention().getPlugin(DefaultAspectjSourceSet.class);
            DefaultAspectjSourceSet testAj = (DefaultAspectjSourceSet)new DslObject((Object)test).getConvention().getPlugin(DefaultAspectjSourceSet.class);
            Configuration aspectpath = project.getConfigurations().getByName(mainAj.getAspectConfigurationName());
            Configuration testAspectpath = project.getConfigurations().getByName(testAj.getAspectConfigurationName());
            testAspectpath.extendsFrom(new Configuration[]{aspectpath});
            testAj.setAspectPath((FileCollection)project.getObjects().fileCollection().from(new Object[]{main.getOutput(), testAspectpath}));
        });
    }

    private void configureSourceSet(SourceSet sourceSet) {
        DefaultAspectjSourceSet aspectjSourceSet = new DefaultAspectjSourceSet(this.project.getObjects(), sourceSet);
        new DslObject((Object)sourceSet).getConvention().getPlugins().put("aspectj", aspectjSourceSet);
        aspectjSourceSet.getAspectj().srcDir((Object)("src/" + sourceSet.getName() + "/aspectj"));
        sourceSet.getResources().getFilter().exclude(element -> aspectjSourceSet.getAspectj().contains(element.getFile()));
        sourceSet.getAllJava().source(aspectjSourceSet.getAspectj());
        sourceSet.getAllSource().source(aspectjSourceSet.getAspectj());
        Configuration aspect = (Configuration)this.project.getConfigurations().create(aspectjSourceSet.getAspectConfigurationName());
        aspectjSourceSet.setAspectPath((FileCollection)aspect);
        Configuration inpath = (Configuration)this.project.getConfigurations().create(aspectjSourceSet.getInpathConfigurationName());
        aspectjSourceSet.setInPath((FileCollection)inpath);
        this.project.getConfigurations().getByName(sourceSet.getCompileConfigurationName()).extendsFrom(new Configuration[]{aspect});
        this.project.getConfigurations().getByName(sourceSet.getCompileOnlyConfigurationName()).extendsFrom(new Configuration[]{inpath});
        TaskProvider compileTask = this.project.getTasks().register(sourceSet.getCompileTaskName("aspectj"), AspectjCompile.class, compile -> {
            SourceSetUtil.configureForSourceSet((SourceSet)sourceSet, (SourceDirectorySet)aspectjSourceSet.getAspectj(), (AbstractCompile)compile, (CompileOptions)compile.getOptions(), (Project)this.project);
            compile.dependsOn(new Object[]{sourceSet.getCompileJavaTaskName()});
            compile.setDescription("Compiles the " + sourceSet.getName() + " AspectJ source.");
            compile.setSource((FileTree)aspectjSourceSet.getAspectj());
            compile.getAjcOptions().getAspectpath().from(new Object[]{aspect});
            compile.getAjcOptions().getInpath().from(new Object[]{inpath});
        });
        SourceSetUtil.configureOutputDirectoryForSourceSet((SourceSet)sourceSet, (SourceDirectorySet)aspectjSourceSet.getAspectj(), (Project)this.project, (Provider)compileTask, (Provider)compileTask.map(AspectjCompile::getOptions));
        this.project.getTasks().named(sourceSet.getClassesTaskName(), arg_0 -> AspectJPlugin.lambda$configureSourceSet$3((Provider)compileTask, arg_0));
    }

    private static /* synthetic */ void lambda$configureSourceSet$3(Provider compileTask, Task task) {
        task.dependsOn(new Object[]{compileTask});
    }
}

