/*
 * Decompiled with CFR 0.152.
 */
package io.formapi;

import io.formapi.ApiClient;
import io.formapi.AuthenticationSuccessResponse;
import io.formapi.CreateSubmissionDataRequestData;
import io.formapi.CreateSubmissionResponse;
import io.formapi.PdfApi;
import io.formapi.Submission;
import io.formapi.SubmissionData;
import io.formapi.SubmissionDataRequest;
import io.formapi.Template;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class PdfApiIntegrationTest {
    private PdfApi api;
    private static final Logger logger = LoggerFactory.getLogger(PdfApiIntegrationTest.class);

    @Before
    public void setup() {
        ApiClient client = new ApiClient("api_token_basic", "api_token123", "testsecret123");
        client.getAdapterBuilder().baseUrl("http://api.formapi.local:31337/api/v1/");
        this.api = (PdfApi)client.createService(PdfApi.class);
    }

    @Test
    public void batchGeneratePdfV1Test() {
        Object templateId = null;
        Object submissionDataBatchV1 = null;
    }

    @Test
    public void batchGeneratePdfsTest() {
        Object submissionBatchData = null;
    }

    @Test
    public void combineSubmissionsTest() {
        Object combinedSubmissionData = null;
    }

    @Test
    public void createDataRequestTokenTest() {
        Object dataRequestId = null;
    }

    @Test
    public void expireCombinedSubmissionTest() {
        Object combinedSubmissionId = null;
    }

    @Test
    public void expireSubmissionTest() {
        Object submissionId = null;
    }

    @Test
    public void generatePDFTest() throws IOException {
        String templateId = "tpl_000000000000000001";
        SubmissionData submissionData = new SubmissionData();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("title", "Test PDF");
        data.put("description", "This PDF is great!");
        submissionData.setData(data);
        Response retrofitResponse = this.api.generatePDF(templateId, submissionData).execute();
        if (!retrofitResponse.isSuccessful()) {
            logger.info(retrofitResponse.errorBody().string());
        }
        Assert.assertEquals((long)201L, (long)retrofitResponse.code());
        CreateSubmissionResponse response = (CreateSubmissionResponse)retrofitResponse.body();
        Assert.assertEquals((Object)CreateSubmissionResponse.StatusEnum.SUCCESS, (Object)response.getStatus());
        Submission submission = response.getSubmission();
        MatcherAssert.assertThat((Object)submission.getId(), (Matcher)Matchers.startsWith((String)"sub_"));
        Assert.assertEquals((Object)false, (Object)submission.getExpired());
        Assert.assertEquals((Object)Submission.StateEnum.PENDING, (Object)submission.getState());
    }

    @Test
    public void generatePDFWithDataRequestTest() throws IOException {
        String templateId = "tpl_000000000000000001";
        SubmissionData submissionData = new SubmissionData();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("title", "Test PDF");
        data.put("description", "This PDF is great!");
        submissionData.setData(data);
        ArrayList<CreateSubmissionDataRequestData> dataRequestsList = new ArrayList<CreateSubmissionDataRequestData>();
        CreateSubmissionDataRequestData dataRequestData = new CreateSubmissionDataRequestData();
        dataRequestData.setAuthType(CreateSubmissionDataRequestData.AuthTypeEnum.EMAIL_LINK);
        dataRequestData.setName("John Smith");
        dataRequestData.setEmail("jsmith@example.com");
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("description");
        dataRequestData.setFields(fields);
        dataRequestsList.add(dataRequestData);
        submissionData.setDataRequests(dataRequestsList);
        Response retrofitResponse = this.api.generatePDF(templateId, submissionData).execute();
        if (!retrofitResponse.isSuccessful()) {
            logger.info(retrofitResponse.errorBody().string());
        }
        Assert.assertEquals((long)201L, (long)retrofitResponse.code());
        CreateSubmissionResponse response = (CreateSubmissionResponse)retrofitResponse.body();
        Assert.assertEquals((Object)CreateSubmissionResponse.StatusEnum.SUCCESS, (Object)response.getStatus());
        Submission submission = response.getSubmission();
        MatcherAssert.assertThat((Object)submission.getId(), (Matcher)Matchers.startsWith((String)"sub_"));
        Assert.assertEquals((Object)false, (Object)submission.getExpired());
        Assert.assertEquals((Object)Submission.StateEnum.WAITING_FOR_DATA_REQUESTS, (Object)submission.getState());
        Assert.assertEquals((long)1L, (long)submission.getDataRequests().size());
        SubmissionDataRequest dataRequest = (SubmissionDataRequest)submission.getDataRequests().get(0);
        MatcherAssert.assertThat((Object)dataRequest.getId(), (Matcher)Matchers.startsWith((String)"drq_"));
        Assert.assertEquals((Object)SubmissionDataRequest.StateEnum.PENDING, (Object)dataRequest.getState());
        MatcherAssert.assertThat((Object)dataRequest.getFields(), (Matcher)CoreMatchers.is(Arrays.asList("description")));
        Assert.assertEquals((Object)new Integer(0), (Object)new Integer(dataRequest.getOrder()));
        Assert.assertEquals((Object)"John Smith", (Object)dataRequest.getName());
        Assert.assertEquals((Object)"jsmith@example.com", (Object)dataRequest.getEmail());
    }

    @Test
    public void getCombinedSubmissionTest() {
        Object combinedSubmissionId = null;
    }

    @Test
    public void getDataRequestTest() {
        Object dataRequestId = null;
    }

    @Test
    public void getSubmissionTest() {
        Object submissionId = null;
    }

    @Test
    public void getSubmissionBatchTest() {
        Object submissionBatchId = null;
        Object includeSubmissions = null;
    }

    @Test
    public void listTemplatesTest() throws IOException {
        Integer perPage;
        String query = "API Client Test Template 2";
        Integer page = 1;
        Response retrofitResponse = this.api.listTemplates(query, null, page, perPage = Integer.valueOf(10)).execute();
        if (!retrofitResponse.isSuccessful()) {
            logger.info(retrofitResponse.errorBody().string());
        }
        Assert.assertEquals((long)200L, (long)retrofitResponse.code());
        List response = (List)retrofitResponse.body();
        Assert.assertEquals((long)1L, (long)response.size());
        Assert.assertEquals((Object)"tpl_000000000000000002", (Object)((Template)response.get(0)).getId());
    }

    @Test
    public void testAuthenticationTest() throws IOException {
        Response response = this.api.testAuthentication().execute();
        Assert.assertEquals((Object)AuthenticationSuccessResponse.StatusEnum.SUCCESS, (Object)((AuthenticationSuccessResponse)response.body()).getStatus());
    }

    @Test
    public void updateDataRequestTest() {
        Object dataRequestId = null;
        Object updateSubmissionDataRequestData = null;
    }
}

