/*
 * API v1
 * FormAPI is a service that helps you fill out and sign PDF templates.
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.formapi;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.formapi.Submission;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * SubmissionBatch
 */
@javax.annotation.Generated(value = "io.formapi.codegen.FormApiJavaClientCodegen", date = "2018-12-01T01:05:42.176+07:00[Asia/Bangkok]")
public class SubmissionBatch {
  public static final String SERIALIZED_NAME_PENDING_COUNT = "pending_count";
  @SerializedName(SERIALIZED_NAME_PENDING_COUNT)
  private Integer pendingCount = null;

  public static final String SERIALIZED_NAME_COMPLETION_PERCENTAGE = "completion_percentage";
  @SerializedName(SERIALIZED_NAME_COMPLETION_PERCENTAGE)
  private Integer completionPercentage = null;

  public static final String SERIALIZED_NAME_METADATA = "metadata";
  @SerializedName(SERIALIZED_NAME_METADATA)
  private Object metadata = null;

  public static final String SERIALIZED_NAME_TOTAL_COUNT = "total_count";
  @SerializedName(SERIALIZED_NAME_TOTAL_COUNT)
  private Integer totalCount = null;

  public static final String SERIALIZED_NAME_SUBMISSIONS = "submissions";
  @SerializedName(SERIALIZED_NAME_SUBMISSIONS)
  private List<Submission> submissions = null;

  public static final String SERIALIZED_NAME_PROCESSED_AT = "processed_at";
  @SerializedName(SERIALIZED_NAME_PROCESSED_AT)
  private String processedAt = null;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id = null;

  /**
   * Gets or Sets state
   */
  @JsonAdapter(StateEnum.Adapter.class)
  public enum StateEnum {
    PENDING("pending"),
    
    PROCESSED("processed"),
    
    ERROR("error");

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StateEnum fromValue(String text) {
      for (StateEnum b : StateEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + text + "'");
    }

    public static class Adapter extends TypeAdapter<StateEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StateEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StateEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return StateEnum.fromValue(String.valueOf(value));
      }
    }
  }

  public static final String SERIALIZED_NAME_STATE = "state";
  @SerializedName(SERIALIZED_NAME_STATE)
  private StateEnum state = null;

  public static final String SERIALIZED_NAME_ERROR_COUNT = "error_count";
  @SerializedName(SERIALIZED_NAME_ERROR_COUNT)
  private Integer errorCount = null;

  public SubmissionBatch pendingCount(Integer pendingCount) {
    this.pendingCount = pendingCount;
    return this;
  }

   /**
   * Get pendingCount
   * @return pendingCount
  **/
  @ApiModelProperty(value = "")
  public Integer getPendingCount() {
    return pendingCount;
  }

  public void setPendingCount(Integer pendingCount) {
    this.pendingCount = pendingCount;
  }

  public SubmissionBatch completionPercentage(Integer completionPercentage) {
    this.completionPercentage = completionPercentage;
    return this;
  }

   /**
   * Get completionPercentage
   * @return completionPercentage
  **/
  @ApiModelProperty(value = "")
  public Integer getCompletionPercentage() {
    return completionPercentage;
  }

  public void setCompletionPercentage(Integer completionPercentage) {
    this.completionPercentage = completionPercentage;
  }

  public SubmissionBatch metadata(Object metadata) {
    this.metadata = metadata;
    return this;
  }

   /**
   * Get metadata
   * @return metadata
  **/
  @ApiModelProperty(value = "")
  public Object getMetadata() {
    return metadata;
  }

  public void setMetadata(Object metadata) {
    this.metadata = metadata;
  }

  public SubmissionBatch totalCount(Integer totalCount) {
    this.totalCount = totalCount;
    return this;
  }

   /**
   * Get totalCount
   * @return totalCount
  **/
  @ApiModelProperty(value = "")
  public Integer getTotalCount() {
    return totalCount;
  }

  public void setTotalCount(Integer totalCount) {
    this.totalCount = totalCount;
  }

  public SubmissionBatch submissions(List<Submission> submissions) {
    this.submissions = submissions;
    return this;
  }

  public SubmissionBatch addSubmissionsItem(Submission submissionsItem) {
    if (this.submissions == null) {
      this.submissions = new ArrayList<Submission>();
    }
    this.submissions.add(submissionsItem);
    return this;
  }

   /**
   * Get submissions
   * @return submissions
  **/
  @ApiModelProperty(value = "")
  public List<Submission> getSubmissions() {
    return submissions;
  }

  public void setSubmissions(List<Submission> submissions) {
    this.submissions = submissions;
  }

  public SubmissionBatch processedAt(String processedAt) {
    this.processedAt = processedAt;
    return this;
  }

   /**
   * Get processedAt
   * @return processedAt
  **/
  @ApiModelProperty(value = "")
  public String getProcessedAt() {
    return processedAt;
  }

  public void setProcessedAt(String processedAt) {
    this.processedAt = processedAt;
  }

  public SubmissionBatch id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(value = "")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public SubmissionBatch state(StateEnum state) {
    this.state = state;
    return this;
  }

   /**
   * Get state
   * @return state
  **/
  @ApiModelProperty(value = "")
  public StateEnum getState() {
    return state;
  }

  public void setState(StateEnum state) {
    this.state = state;
  }

  public SubmissionBatch errorCount(Integer errorCount) {
    this.errorCount = errorCount;
    return this;
  }

   /**
   * Get errorCount
   * @return errorCount
  **/
  @ApiModelProperty(value = "")
  public Integer getErrorCount() {
    return errorCount;
  }

  public void setErrorCount(Integer errorCount) {
    this.errorCount = errorCount;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SubmissionBatch submissionBatch = (SubmissionBatch) o;
    return Objects.equals(this.pendingCount, submissionBatch.pendingCount) &&
        Objects.equals(this.completionPercentage, submissionBatch.completionPercentage) &&
        Objects.equals(this.metadata, submissionBatch.metadata) &&
        Objects.equals(this.totalCount, submissionBatch.totalCount) &&
        Objects.equals(this.submissions, submissionBatch.submissions) &&
        Objects.equals(this.processedAt, submissionBatch.processedAt) &&
        Objects.equals(this.id, submissionBatch.id) &&
        Objects.equals(this.state, submissionBatch.state) &&
        Objects.equals(this.errorCount, submissionBatch.errorCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pendingCount, completionPercentage, metadata, totalCount, submissions, processedAt, id, state, errorCount);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SubmissionBatch {\n");
    
    sb.append("    pendingCount: ").append(toIndentedString(pendingCount)).append("\n");
    sb.append("    completionPercentage: ").append(toIndentedString(completionPercentage)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    totalCount: ").append(toIndentedString(totalCount)).append("\n");
    sb.append("    submissions: ").append(toIndentedString(submissions)).append("\n");
    sb.append("    processedAt: ").append(toIndentedString(processedAt)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    errorCount: ").append(toIndentedString(errorCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

