package io.fogcloud.sdk.mqtt.api;

import android.content.Context;

import io.fogcloud.sdk.mqtt.helper.ComHelper;
import io.fogcloud.sdk.mqtt.helper.ListenDeviceCallBack;
import io.fogcloud.sdk.mqtt.helper.ListenDeviceParams;
import io.fogcloud.sdk.mqtt.helper.MQTTErrCode;
import io.fogcloud.sdk.mqtt.service.MqttServiceAPI;
import io.fogcloud.sdk.mqtt.service.MqttServiceListener;

/**
 * 
 * @author Rocke by 2015-08-24
 * 
 */
public class MQTT {
	private MqttServiceAPI micomqtt;
	private Context mContext;
	
	//is mqtt working
	private boolean isWorking = false;

	public MQTT(Context context) {
		micomqtt = new MqttServiceAPI();
		this.mContext = context;
	}

	/**
	 * connect the mqtt server
	 * 
	 * @param listendevparams the paraments of listener
	 * @param ctrldevcb listen the callback
	 */
	public void startMqtt(ListenDeviceParams listendevparams,
			final ListenDeviceCallBack ctrldevcb) {
		String topic = listendevparams.topic;
		String host = listendevparams.host;
		String userName = listendevparams.userName;
		String passWord = listendevparams.passWord;
		String clientID = listendevparams.clientID;
		boolean isencrypt = listendevparams.isencrypt;

		if (ComHelper.checkPara(host, userName, passWord, clientID)) {
			if(!isWorking){
				isWorking = true;
				String port = listendevparams.port;
					if (null != mContext) {
						micomqtt.startMqttService(mContext, host, port,
								userName, passWord, clientID, topic, isencrypt,
								new MqttServiceListener() {
									@Override
									public void onMqttReceiver(int code, String messages) {
										ComHelper.onDevStatusReceived(code, messages, ctrldevcb);
									}
								});
	
						ComHelper.successCBCtrlDev(MQTTErrCode.SUCCESS_CODE, MQTTErrCode.SUCCESS, ctrldevcb);
					} else {
						ComHelper.failureCBCtrlDev(MQTTErrCode.CONTEXT_CODE, MQTTErrCode.CONTEXT, ctrldevcb);
					}
			}else{
				ComHelper.failureCBCtrlDev(MQTTErrCode.BUSY_CODE, MQTTErrCode.BUSY, ctrldevcb);
			}
		} else {
			ComHelper.failureCBCtrlDev(MQTTErrCode.EMPTY_CODE, MQTTErrCode.EMPTY, ctrldevcb);
		}
	}

	/**
	 * send command
	 * @param topic topics
	 * @param command the command to the device
	 * @param qos 012
	 * @param retained 0
	 * @param ctrldevcb listen the callback
	 */
	public void publish(String topic,
			String command,
			int qos,
			boolean retained, 
			final ListenDeviceCallBack ctrldevcb) {
		if(isWorking){
			if (ComHelper.checkPara(topic, command)) {
				if(0 == qos|| 1 == qos || 2 == qos){
					micomqtt.publishCommand(topic, command, qos, retained);
				}else{
					ComHelper.failureCBCtrlDev(MQTTErrCode.QOS_CODE, MQTTErrCode.QOSERR, ctrldevcb);
					return;
				}
			} else {
				ComHelper.failureCBCtrlDev(MQTTErrCode.EMPTY_CODE, MQTTErrCode.EMPTY, ctrldevcb);
			}
		}else{
			ComHelper.failureCBCtrlDev(MQTTErrCode.CLOSED_CODE, MQTTErrCode.CLOSED, ctrldevcb);
		}
	}

	/**
	 * add topic
	 * @param topic topics
	 * @param qos 0 1 2
	 * @param ctrldevcb listen the callback
	 */
	public void subscribe(String topic, int qos, ListenDeviceCallBack ctrldevcb) {
		if(isWorking){
			if (ComHelper.checkPara(topic)) {
				if(0 == qos|| 1 == qos || 2 == qos){
					micomqtt.subscribe(topic, qos);
					ComHelper.successCBCtrlDev(MQTTErrCode.SUCCESS_CODE, MQTTErrCode.SUCCESS, ctrldevcb);
				} else {
					ComHelper.failureCBCtrlDev(MQTTErrCode.QOS_CODE, MQTTErrCode.QOSERR, ctrldevcb);
					return;
				}
			} else {
				ComHelper.failureCBCtrlDev(MQTTErrCode.EMPTY_CODE, MQTTErrCode.EMPTY, ctrldevcb);
			}
		}else{
			ComHelper.failureCBCtrlDev(MQTTErrCode.CLOSED_CODE, MQTTErrCode.CLOSED, ctrldevcb);
		}
	}

	/**
	 * remove the topic
	 * @param topic topics
	 * @param ctrldevcb listen the callback
	 */
	public void unsubscribe(String topic, ListenDeviceCallBack ctrldevcb) {
		if(isWorking){
			if (ComHelper.checkPara(topic)) {
				micomqtt.unsubscribe(topic);
				ComHelper.successCBCtrlDev(MQTTErrCode.SUCCESS_CODE, MQTTErrCode.SUCCESS, ctrldevcb);
			} else {
				ComHelper.failureCBCtrlDev(MQTTErrCode.EMPTY_CODE, MQTTErrCode.EMPTY, ctrldevcb);
			}
		}else{
			ComHelper.failureCBCtrlDev(MQTTErrCode.CLOSED_CODE, MQTTErrCode.CLOSED, ctrldevcb);
		}
	}

	/**
	 * close the connect
	 * @param ctrldevcb listen the callback
	 */
	public void stopMqtt(ListenDeviceCallBack ctrldevcb) {
		if(isWorking){
			isWorking = false;
			if (null != mContext) {
				micomqtt.stopMqttService(mContext);
				ComHelper.successCBCtrlDev(MQTTErrCode.SUCCESS_CODE, MQTTErrCode.SUCCESS, ctrldevcb);
			} else {
				ComHelper.failureCBCtrlDev(MQTTErrCode.CONTEXT_CODE, MQTTErrCode.CONTEXT, ctrldevcb);
			}
		}else{
			ComHelper.failureCBCtrlDev(MQTTErrCode.CLOSED_CODE, MQTTErrCode.CLOSED, ctrldevcb);
		}
	}
}
